/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.SyntaxError;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.TextRangeTracker;
import org.sonarsource.kotlin.api.regex.AbstractRegexCheck;
import org.sonarsource.kotlin.api.regex.RegexContext;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;

@Rule(key="S5856")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/InvalidRegexCheck;", "Lorg/sonarsource/kotlin/api/regex/AbstractRegexCheck;", "<init>", "()V", "visitRegex", "", "regex", "Lorg/sonarsource/analyzer/commons/regex/RegexParseResult;", "regexContext", "Lorg/sonarsource/kotlin/api/regex/RegexContext;", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "matchedFun", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class InvalidRegexCheck
extends AbstractRegexCheck {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitRegex(@NotNull RegexParseResult regex, @NotNull RegexContext regexContext, @NotNull KtCallExpression callExpression, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        Intrinsics.checkNotNullParameter(regexContext, "regexContext");
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List<SyntaxError> syntaxErrorLocs = regex.getSyntaxErrors();
        TextRangeTracker textRangeTracker = regexContext.getRegexSource().getTextRangeTracker();
        if (syntaxErrorLocs.size() == 1) {
            Intrinsics.checkNotNull(syntaxErrorLocs);
            SyntaxError first2 = CollectionsKt.first(syntaxErrorLocs);
            RegexSyntaxElement regexSyntaxElement = first2.getOffendingSyntaxElement();
            Intrinsics.checkNotNullExpressionValue(regexSyntaxElement, "getOffendingSyntaxElement(...)");
            String string = first2.getMessage();
            Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
            RegexContext.reportIssue$default(regexContext, regexSyntaxElement, string, null, null, 12, null);
        } else if (syntaxErrorLocs.size() > 1) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNull(syntaxErrorLocs);
            Iterable $this$mapNotNull$iv = syntaxErrorLocs;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                List list;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                SyntaxError syntaxError = (SyntaxError)element$iv$iv;
                boolean bl2 = false;
                IndexRange indexRange = syntaxError.getOffendingSyntaxElement().getRange();
                Intrinsics.checkNotNullExpressionValue(indexRange, "getRange(...)");
                List<TextRange> list2 = this.mergeTextRanges(kotlinFileContext, (Iterable<? extends TextRange>)textRangeTracker.textRangesBetween(indexRange));
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable2 = list2;
                    boolean $i$f$map = false;
                    void var25_26 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        TextRange textRange = (TextRange)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull(it);
                        collection.add(new SecondaryLocation((TextRange)it, syntaxError.getMessage()));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = null;
                }
                if (list == null) continue;
                List it$iv$iv = list;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List secondaries = CollectionsKt.flatten((List)destination$iv$iv);
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Fix the syntax errors inside this regex.", secondaries, null, 8, null);
        }
    }
}

