/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.InterfaceCouldBeFunctionalCheckKt;

@Rule(key="S6517")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/checks/InterfaceCouldBeFunctionalCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "functionalInterClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "checkFunctionalInterface", "checkFunctionalInterfaceAnnotation", "sonar-kotlin-checks"})
public final class InterfaceCouldBeFunctionalCheck
extends AbstractCheck {
    @NotNull
    private final ClassId functionalInterClassId = ClassId.Companion.fromString$default(ClassId.Companion, "java/lang/FunctionalInterface", false, 2, null);

    @Override
    public void visitClass(@NotNull KtClass klass, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(context, "context");
        this.checkFunctionalInterface(klass, context);
        this.checkFunctionalInterfaceAnnotation(klass, context);
    }

    private final void checkFunctionalInterface(KtClass klass, KotlinFileContext context) {
        boolean isNonFunctionalInterface;
        boolean bl = isNonFunctionalInterface = klass.isInterface() && klass.getFunKeyword() == null;
        if (isNonFunctionalInterface && InterfaceCouldBeFunctionalCheckKt.access$hasExactlyOneFunctionAndNoProperties(klass) && !klass.isSealed()) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = klass.getClassOrInterfaceKeyword();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, context, psiElement, "Make this interface functional or replace it with a function type.", null, null, 12, null);
        }
    }

    private final void checkFunctionalInterfaceAnnotation(KtClass klass, KotlinFileContext context) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$checkFunctionalInterfaceAnnotation_u24lambda_u241 = kaSession;
        boolean bl = false;
        List<KtAnnotationEntry> list = klass.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
            boolean bl2 = false;
            Object object = it.getTypeReference();
            boolean bl3 = object != null && (object = $this$checkFunctionalInterfaceAnnotation_u24lambda_u241.getType((KtTypeReference)object)) != null ? $this$checkFunctionalInterfaceAnnotation_u24lambda_u241.isClassType((KaType)object, this.functionalInterClassId) : false;
            if (!bl3) continue;
            AbstractCheck abstractCheck = this;
            Intrinsics.checkNotNull(it);
            AbstractCheck.reportIssue$default(abstractCheck, context, (PsiElement)it, "\"@FunctionalInterface\" annotation has no effect in Kotlin", null, null, 12, null);
        }
    }
}

