/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.ImplicitParameterInLambdaCheckKt;

@Rule(key="S6558")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\u0007H\u0002J\f\u0010\f\u001a\u00020\u000b*\u00020\u0007H\u0002J\f\u0010\r\u001a\u00020\u000b*\u00020\u0007H\u0002J\f\u0010\u000e\u001a\u00020\u000b*\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/sonarsource/kotlin/checks/ImplicitParameterInLambdaCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitLambdaExpression", "", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "isArgumentWithImplicitParameterDeclarationWithoutReferenceType", "", "isArgument", "isPropertyWithReferenceTypeAndImplicitParameterDeclaration", "isPropertyWithTypeReference", "sonar-kotlin-checks"})
public final class ImplicitParameterInLambdaCheck
extends AbstractCheck {
    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(lambdaExpression, "lambdaExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (this.isArgumentWithImplicitParameterDeclarationWithoutReferenceType(lambdaExpression) || this.isPropertyWithReferenceTypeAndImplicitParameterDeclaration(lambdaExpression)) {
            KtParameterList ktParameterList = lambdaExpression.getFunctionLiteral().getValueParameterList();
            Intrinsics.checkNotNull(ktParameterList);
            KtParameterList lambdaValueParameterList = ktParameterList;
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)lambdaValueParameterList, ImplicitParameterInLambdaCheckKt.access$buildReportMessage(), null, null, 12, null);
        }
    }

    private final boolean isArgumentWithImplicitParameterDeclarationWithoutReferenceType(KtLambdaExpression $this$isArgumentWithImplicitParameterDeclarationWithoutReferenceType) {
        return this.isArgument($this$isArgumentWithImplicitParameterDeclarationWithoutReferenceType) && ImplicitParameterInLambdaCheckKt.access$hasImplicitParameter($this$isArgumentWithImplicitParameterDeclarationWithoutReferenceType) && $this$isArgumentWithImplicitParameterDeclarationWithoutReferenceType.getValueParameters().get(0).getTypeReference() == null;
    }

    private final boolean isArgument(KtLambdaExpression $this$isArgument) {
        PsiElement it = this.skipParentParentheses($this$isArgument.getParent());
        boolean bl = false;
        return it instanceof KtLambdaArgument || it instanceof KtValueArgument;
    }

    private final boolean isPropertyWithReferenceTypeAndImplicitParameterDeclaration(KtLambdaExpression $this$isPropertyWithReferenceTypeAndImplicitParameterDeclaration) {
        return this.isPropertyWithTypeReference($this$isPropertyWithReferenceTypeAndImplicitParameterDeclaration) && ImplicitParameterInLambdaCheckKt.access$hasImplicitParameter($this$isPropertyWithReferenceTypeAndImplicitParameterDeclaration);
    }

    private final boolean isPropertyWithTypeReference(KtLambdaExpression $this$isPropertyWithTypeReference) {
        PsiElement psiElement = this.skipParentParentheses($this$isPropertyWithTypeReference.getParent());
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        return (ktProperty != null ? ktProperty.getTypeReference() : null) != null;
    }
}

