/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.analyzer.commons.EntropyDetector;
import org.sonarsource.analyzer.commons.HumanLanguageDetector;
import org.sonarsource.kotlin.checks.AbstractHardcodedVisitor;

@Rule(key="S6418")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/sonarsource/kotlin/checks/HardcodedSecretsCheck;", "Lorg/sonarsource/kotlin/checks/AbstractHardcodedVisitor;", "<init>", "()V", "secretWords", "", "getSecretWords", "()Ljava/lang/String;", "setSecretWords", "(Ljava/lang/String;)V", "randomnessSensibility", "", "getRandomnessSensibility", "()D", "setRandomnessSensibility", "(D)V", "entropyDetector", "Lorg/sonarsource/analyzer/commons/EntropyDetector;", "maxLanguageScore", "sensitiveVariableKind", "getSensitiveVariableKind", "sensitiveWords", "getSensitiveWords", "getEntropyDetector", "isSensitiveStringLiteral", "", "value", "sonar-kotlin-checks"})
public final class HardcodedSecretsCheck
extends AbstractHardcodedVisitor {
    @RuleProperty(key="secretWords", description="Comma separated list of words identifying potential secrets", defaultValue="api[_.-]?key,auth,credential,secret,token")
    @NotNull
    private String secretWords = "api[_.-]?key,auth,credential,secret,token";
    @RuleProperty(key="randomnessSensibility", description="Allows to tune the Randomness Sensibility (from 0 to 10)", defaultValue="3.0")
    private double randomnessSensibility = Double.parseDouble("3.0");
    private EntropyDetector entropyDetector;
    private double maxLanguageScore;

    @NotNull
    public final String getSecretWords() {
        return this.secretWords;
    }

    public final void setSecretWords(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.secretWords = string;
    }

    public final double getRandomnessSensibility() {
        return this.randomnessSensibility;
    }

    public final void setRandomnessSensibility(double d2) {
        this.randomnessSensibility = d2;
    }

    @Override
    @NotNull
    public String getSensitiveVariableKind() {
        return "secret";
    }

    @Override
    @NotNull
    public String getSensitiveWords() {
        return this.secretWords;
    }

    private final EntropyDetector getEntropyDetector() {
        EntropyDetector entropyDetector;
        if (this.entropyDetector == null) {
            this.entropyDetector = new EntropyDetector(this.randomnessSensibility);
        }
        if ((entropyDetector = this.entropyDetector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("entropyDetector");
            entropyDetector = null;
        }
        return entropyDetector;
    }

    @Override
    public boolean isSensitiveStringLiteral(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return ((CharSequence)value2).length() > 0 && value2.length() >= 17 && this.getEntropyDetector().hasEnoughEntropy(value2) && HumanLanguageDetector.humanLanguageScore(value2) < this.maxLanguageScore();
    }

    private final double maxLanguageScore() {
        if (this.maxLanguageScore == 0.0) {
            this.maxLanguageScore = ((double)10 - this.randomnessSensibility) * 0.3;
        }
        return this.maxLanguageScore;
    }
}

