/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.AbstractHardcodedVisitor;

@Rule(key="S2068")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/sonarsource/kotlin/checks/HardcodedCredentialsCheck;", "Lorg/sonarsource/kotlin/checks/AbstractHardcodedVisitor;", "<init>", "()V", "credentialWords", "", "getCredentialWords", "()Ljava/lang/String;", "setCredentialWords", "(Ljava/lang/String;)V", "sensitiveVariableKind", "getSensitiveVariableKind", "sensitiveWords", "getSensitiveWords", "visitStringTemplateExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "Companion", "sonar-kotlin-checks"})
public final class HardcodedCredentialsCheck
extends AbstractHardcodedVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd,passphrase")
    @NotNull
    private String credentialWords = "password,passwd,pwd,passphrase";
    @NotNull
    private static final String DEFAULT_VALUE = "password,passwd,pwd,passphrase";
    @NotNull
    private static final Regex URI_PREFIX = new Regex("^\\w{1,8}://");

    @NotNull
    public final String getCredentialWords() {
        return this.credentialWords;
    }

    public final void setCredentialWords(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.credentialWords = string;
    }

    @Override
    @NotNull
    public String getSensitiveVariableKind() {
        return "credential";
    }

    @Override
    @NotNull
    public String getSensitiveWords() {
        return this.credentialWords;
    }

    @Override
    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, @NotNull KotlinFileContext context) {
        String content;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        String string = content = !expression.hasInterpolation() ? this.asConstant(expression) : "";
        if (HardcodedCredentialsCheck.Companion.isURIWithCredentials(content)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)expression, "Review this hard-coded URL, which may contain a credential.", null, null, 12, null);
        } else {
            super.visitStringTemplateExpression(expression, context);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/sonarsource/kotlin/checks/HardcodedCredentialsCheck$Companion;", "", "<init>", "()V", "DEFAULT_VALUE", "", "URI_PREFIX", "Lkotlin/text/Regex;", "isURIWithCredentials", "", "stringLiteral", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isURIWithCredentials(String stringLiteral) {
            if (URI_PREFIX.containsMatchIn(stringLiteral)) {
                try {
                    String userInfo = new URI(stringLiteral).getUserInfo();
                    if (userInfo != null) {
                        String[] stringArray = new String[]{":"};
                        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)userInfo, stringArray, false, 0, 6, null);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] parts = thisCollection$iv.toArray(new String[0]);
                        return parts.length > 1 && !Intrinsics.areEqual(parts[0], parts[1]) && (parts.length != 2 || !(((CharSequence)parts[1]).length() == 0));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

