/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.CognitiveComplexity;

@Rule(key="S3776")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/sonarsource/kotlin/checks/FunctionCognitiveComplexityCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "threshold", "", "getThreshold", "()I", "setThreshold", "(I)V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "secondaryLocation", "Lorg/sonarsource/kotlin/api/reporting/SecondaryLocation;", "increment", "Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;", "Companion", "sonar-kotlin-checks"})
public final class FunctionCognitiveComplexityCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;
    private static final int DEFAULT_THRESHOLD = 15;

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n2) {
        this.threshold = n2;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = function2.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        CognitiveComplexity complexity = new CognitiveComplexity(function2);
        int value2 = complexity.value();
        if (value2 > this.threshold) {
            String string = "Refactor this method to reduce its Cognitive Complexity from " + value2 + " to the " + this.threshold + " allowed.";
            List<SecondaryLocation> list = complexity.increments().stream().map(arg_0 -> FunctionCognitiveComplexityCheck.visitNamedFunction$lambda$1(arg_0 -> FunctionCognitiveComplexityCheck.visitNamedFunction$lambda$0(this, context, arg_0), arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, "collect(...)");
            this.reportIssue(context, nameIdentifier, string, list, (Double)((double)value2 - (double)this.threshold));
        }
    }

    private final SecondaryLocation secondaryLocation(CognitiveComplexity.Increment increment, KotlinFileContext context) {
        int nestingLevel = increment.getNestingLevel();
        String message = "+" + (nestingLevel + 1);
        if (nestingLevel > 0) {
            message = message + " (incl " + nestingLevel + " for nesting)";
        }
        TextRange textRange = KotlinTextRanges.INSTANCE.textRange(context, increment.getToken());
        return new SecondaryLocation(textRange, message);
    }

    private static final SecondaryLocation visitNamedFunction$lambda$0(FunctionCognitiveComplexityCheck this$0, KotlinFileContext $context, CognitiveComplexity.Increment increment) {
        Intrinsics.checkNotNullParameter(increment, "increment");
        return this$0.secondaryLocation(increment, $context);
    }

    private static final SecondaryLocation visitNamedFunction$lambda$1(Function1 $tmp0, Object p0) {
        return (SecondaryLocation)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/FunctionCognitiveComplexityCheck$Companion;", "", "<init>", "()V", "DEFAULT_THRESHOLD", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

