/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020(H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/sonarsource/kotlin/checks/FinallyBlockVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "report", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "loopDepthCounter", "", "functionDepthCounter", "stackedLabels", "Ljava/util/Stack;", "", "alreadyEnteredFinallyBlock", "", "visitLabeledExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitFinallySection", "finallySection", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "checkAndVisit", "depthCounter", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "sonar-kotlin-checks"})
final class FinallyBlockVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final Function1<KtExpression, Unit> report;
    private int loopDepthCounter;
    private int functionDepthCounter;
    @NotNull
    private final Stack<String> stackedLabels;
    private boolean alreadyEnteredFinallyBlock;

    public FinallyBlockVisitor(@NotNull Function1<? super KtExpression, Unit> report2) {
        Intrinsics.checkNotNullParameter(report2, "report");
        this.report = report2;
        this.stackedLabels = new Stack();
    }

    @Override
    public void visitLabeledExpression(@NotNull KtLabeledExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.stackedLabels.push(expression.getName());
        super.visitLabeledExpression(expression);
        this.stackedLabels.pop();
    }

    @Override
    public void visitFinallySection(@NotNull KtFinallySection finallySection) {
        Intrinsics.checkNotNullParameter(finallySection, "finallySection");
        if (!this.alreadyEnteredFinallyBlock) {
            this.alreadyEnteredFinallyBlock = true;
            super.visitFinallySection(finallySection);
        }
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.stackedLabels.push(expression.getFirstChild().getText());
        super.visitCallExpression(expression);
        this.stackedLabels.pop();
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        int n2 = this.loopDepthCounter;
        this.loopDepthCounter = n2 + 1;
        super.visitLoopExpression(loopExpression);
        n2 = this.loopDepthCounter;
        this.loopDepthCounter = n2 + -1;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        int n2 = this.functionDepthCounter;
        this.functionDepthCounter = n2 + 1;
        super.visitNamedFunction(function2);
        n2 = this.functionDepthCounter;
        this.functionDepthCounter = n2 + -1;
    }

    @Override
    public void visitBreakExpression(@NotNull KtBreakExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.checkAndVisit(this.loopDepthCounter, expression);
    }

    @Override
    public void visitContinueExpression(@NotNull KtContinueExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.checkAndVisit(this.loopDepthCounter, expression);
    }

    @Override
    public void visitReturnExpression(@NotNull KtReturnExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.checkAndVisit(this.functionDepthCounter, expression);
    }

    @Override
    public void visitThrowExpression(@NotNull KtThrowExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        if (this.functionDepthCounter == 0) {
            this.report.invoke(expression);
        }
    }

    private final void checkAndVisit(int depthCounter, KtExpressionWithLabel expression) {
        if (expression.getLabelQualifier() != null) {
            String string = expression.getLabelName();
            Intrinsics.checkNotNull(string);
            if (!this.stackedLabels.contains(string)) {
                this.report.invoke(expression);
            }
        } else if (depthCounter == 0) {
            this.report.invoke(expression);
        }
        this.visitExpressionWithLabel(expression);
    }
}

