/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S108")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/checks/EmptyBlockCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "message", "", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "sonar-kotlin-checks"})
public final class EmptyBlockCheck
extends AbstractCheck {
    @NotNull
    private final String message;

    public EmptyBlockCheck() {
        this.message = "Either remove or fill this block of code.";
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (expression.getEntries().isEmpty() && !this.hasComment(expression)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)expression, this.message, null, null, 12, null);
        }
    }

    @Override
    public void visitBlockExpression(@NotNull KtBlockExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (expression.getStatements().isEmpty() && !this.hasComment(expression) && !(expression.getParent() instanceof KtFunction) && !(expression.getParent().getParent() instanceof KtWhileExpression)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)expression, this.message, null, null, 12, null);
        }
    }
}

