/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S126")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\u0007H\u0002J\f\u0010\f\u001a\u00020\u000b*\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/checks/ElseIfWithoutElseCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitIfExpression", "", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "isTopLevelIf", "", "terminates", "sonar-kotlin-checks"})
public final class ElseIfWithoutElseCheck
extends AbstractCheck {
    @Override
    public void visitIfExpression(@NotNull KtIfExpression ifExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(ifExpression, "ifExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (ifExpression.getElse() == null || !this.isTopLevelIf(ifExpression)) {
            return;
        }
        KtIfExpression lastIfExpression = ifExpression;
        boolean allTerminate = this.terminates(lastIfExpression);
        while (lastIfExpression.getElse() instanceof KtIfExpression) {
            KtExpression ktExpression = lastIfExpression.getElse();
            Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            lastIfExpression = (KtIfExpression)ktExpression;
            allTerminate = allTerminate && this.terminates(lastIfExpression);
        }
        if (!allTerminate && lastIfExpression.getElse() == null) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = lastIfExpression.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, "Add the missing \"else\" clause.", null, null, 12, null);
        }
    }

    private final boolean isTopLevelIf(KtIfExpression $this$isTopLevelIf) {
        PsiElement parent2 = $this$isTopLevelIf.getParent().getParent();
        return parent2 instanceof KtIfExpression ? !Intrinsics.areEqual(((KtIfExpression)parent2).getElse(), $this$isTopLevelIf) : true;
    }

    private final boolean terminates(KtIfExpression $this$terminates) {
        KtExpression ktExpression = $this$terminates.getThen();
        KtExpression ktExpression2 = ktExpression != null ? KtPsiUtilKt.lastBlockStatementOrThis(ktExpression) : null;
        return ktExpression2 instanceof KtReturnExpression || ktExpression2 instanceof KtThrowExpression || ktExpression2 instanceof KtBreakExpression || ktExpression2 instanceof KtContinueExpression;
    }
}

