/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.sonar.api.batch.fs.TextRange;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"hasSameSignature", "", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "other", "spansMultipleLines", "tree", "Lorg/jetbrains/kotlin/psi/KtElement;", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class DuplicateBranchCheckKt {
    private static final boolean hasSameSignature(KtQualifiedExpression $this$hasSameSignature, KtQualifiedExpression other) {
        return Intrinsics.areEqual(ApiExtensionsKt.determineSignature($this$hasSameSignature), ApiExtensionsKt.determineSignature(other));
    }

    private static final boolean spansMultipleLines(KtElement tree, KotlinFileContext ctx) {
        if (tree instanceof KtBlockExpression) {
            List<KtExpression> list = ((KtBlockExpression)tree).getStatements();
            Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
            List<KtExpression> statements = list;
            if (statements.isEmpty()) {
                return false;
            }
            KtExpression firstStatement = statements.get(0);
            KtExpression lastStatement = statements.get(statements.size() - 1);
            Intrinsics.checkNotNull(firstStatement);
            TextRange firstTextRange = KotlinTextRanges.INSTANCE.textRange(ctx, firstStatement);
            Intrinsics.checkNotNull(lastStatement);
            TextRange lastTextRange = KotlinTextRanges.INSTANCE.textRange(ctx, lastStatement);
            return firstTextRange.start().line() != lastTextRange.end().line();
        }
        TextRange range = KotlinTextRanges.INSTANCE.textRange(ctx, tree);
        return range.start().line() < range.end().line();
    }

    public static final /* synthetic */ boolean access$spansMultipleLines(KtElement tree, KotlinFileContext ctx) {
        return DuplicateBranchCheckKt.spansMultipleLines(tree, ctx);
    }

    public static final /* synthetic */ boolean access$hasSameSignature(KtQualifiedExpression $receiver, KtQualifiedExpression other) {
        return DuplicateBranchCheckKt.hasSameSignature($receiver, other);
    }
}

