/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.AbstractBranchDuplication;
import org.sonarsource.kotlin.checks.DuplicateBranchCheckKt;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Rule(key="S1871")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/checks/DuplicateBranchCheck;", "Lorg/sonarsource/kotlin/checks/AbstractBranchDuplication;", "<init>", "()V", "checkDuplicatedBranches", "", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "tree", "Lorg/jetbrains/kotlin/psi/KtElement;", "branches", "", "onAllIdenticalBranches", "sonar-kotlin-checks"})
public final class DuplicateBranchCheck
extends AbstractBranchDuplication {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkDuplicatedBranches(@NotNull KotlinFileContext ctx, @NotNull KtElement tree, @NotNull List<? extends KtElement> branches) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(branches, "branches");
        for (List<KtElement> group : SyntacticEquivalence.INSTANCE.findDuplicatedGroups(branches)) {
            void $this$forEach$iv;
            KtElement original = group.get(0);
            Sequence<KtElement> sequence2 = SequencesKt.filter(SequencesKt.filter(SequencesKt.drop(CollectionsKt.asSequence((Iterable)group), 1), arg_0 -> DuplicateBranchCheck.checkDuplicatedBranches$lambda$0(ctx, arg_0)), arg_0 -> DuplicateBranchCheck.checkDuplicatedBranches$lambda$1(original, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtElement duplicated = (KtElement)element$iv;
                boolean bl = false;
                TextRange originalRange = KotlinTextRanges.INSTANCE.textRange(ctx, original);
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)duplicated, "This branch's code block is the same as the block for the branch on line " + originalRange.start().line() + ".", CollectionsKt.listOf(new SecondaryLocation(originalRange, "Original")), null, 8, null);
            }
        }
    }

    @Override
    protected void onAllIdenticalBranches(@NotNull KotlinFileContext ctx, @NotNull KtElement tree) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(tree, "tree");
    }

    private static final boolean checkDuplicatedBranches$lambda$0(KotlinFileContext $ctx, KtElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DuplicateBranchCheckKt.access$spansMultipleLines(it, $ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkDuplicatedBranches$lambda$1(KtElement $original, KtElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!(it instanceof KtQualifiedExpression)) return true;
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)it;
        Intrinsics.checkNotNull($original, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        if (!DuplicateBranchCheckKt.access$hasSameSignature(ktQualifiedExpression, (KtQualifiedExpression)$original)) return false;
        return true;
    }
}

