/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.DataHashingCheckKt;
import org.sonarsource.kotlin.checks.InsecureAlgorithm;

@Rule(key="S4790")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/DataHashingCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class DataHashingCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        block12: {
            InsecureAlgorithm algorithm;
            boolean bl;
            KtExpression calleeExpression;
            block10: {
                FunMatcherImpl it;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block11: {
                    boolean bl2;
                    block9: {
                        Intrinsics.checkNotNullParameter(expression, "expression");
                        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                        KtExpression ktExpression = expression.getCalleeExpression();
                        if (ktExpression == null) {
                            return;
                        }
                        calleeExpression = ktExpression;
                        $this$any$iv = DataHashingCheckKt.access$getDEPRECATED_SPRING_PASSWORD_ENCODER_METHODS$p();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (FunMatcherImpl)element$iv;
                                boolean bl3 = false;
                                if (!it.matches(expression)) continue;
                                bl2 = true;
                                break block9;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) break block11;
                    AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)calleeExpression, "Make sure this weak hash algorithm is not used in a sensitive context here.", null, null, 12, null);
                    break block12;
                }
                $this$any$iv = DataHashingCheckKt.access$getWEAK_METHOD_MATCHERS$p();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (FunMatcherImpl)element$iv;
                        boolean bl4 = false;
                        if (!it.matches(expression)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (!bl) break block12;
            InsecureAlgorithm insecureAlgorithm = (InsecureAlgorithm)((Object)DataHashingCheckKt.access$getALGORITHM_BY_METHOD_NAME$p().get(calleeExpression.getText()));
            if (insecureAlgorithm == null) {
                List<KtValueArgument> list = expression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
                KtValueArgument ktValueArgument = CollectionsKt.firstOrNull(list);
                insecureAlgorithm = DataHashingCheckKt.access$algorithm(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null);
            }
            InsecureAlgorithm insecureAlgorithm2 = algorithm = insecureAlgorithm;
            if (insecureAlgorithm2 != null) {
                InsecureAlgorithm it = insecureAlgorithm2;
                boolean bl5 = false;
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)calleeExpression, "Make sure this weak hash algorithm is not used in a sensitive context here.", null, null, 12, null);
            }
        }
    }
}

