/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.CollectionSizeAndArrayLengthCheckKt;

@Rule(key="S3981")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J;\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0016\u001a\u00020\u0017*\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0018J\u0011\u0010\u0019\u001a\u00020\u0017*\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/sonarsource/kotlin/checks/CollectionSizeAndArrayLengthCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitBinaryExpression", "", "bet", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "fileCtx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "checkConditionsAndSelectMessage", "", "opToken", "Lcom/intellij/psi/tree/IElementType;", "testedExpr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "integerValue", "", "opWithEq", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "opWithoutEq", "(Lcom/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/Integer;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;)Ljava/lang/String;", "isZeroOrNegative", "", "(Ljava/lang/Integer;)Z", "isNegative", "sonar-kotlin-checks"})
public final class CollectionSizeAndArrayLengthCheck
extends AbstractCheck {
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression bet, @NotNull KotlinFileContext fileCtx) {
        block4: {
            String msg;
            String string;
            Integer rightIntValue;
            Intrinsics.checkNotNullParameter(bet, "bet");
            Intrinsics.checkNotNullParameter(fileCtx, "fileCtx");
            IElementType iElementType = bet.getOperationToken();
            Intrinsics.checkNotNullExpressionValue(iElementType, "getOperationToken(...)");
            IElementType opToken = iElementType;
            KtExpression ktExpression = bet.getLeft();
            Integer leftIntValue = ktExpression != null ? ApiExtensionsKt.predictRuntimeIntValue(ktExpression) : null;
            KtExpression ktExpression2 = bet.getRight();
            Integer n2 = rightIntValue = ktExpression2 != null ? ApiExtensionsKt.predictRuntimeIntValue(ktExpression2) : null;
            if (this.isZeroOrNegative(leftIntValue)) {
                KtExpression ktExpression3 = bet.getRight();
                KtSingleValueToken ktSingleValueToken = KtTokens.LTEQ;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "LTEQ");
                KtSingleValueToken ktSingleValueToken2 = KtTokens.GT;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken2, "GT");
                string = this.checkConditionsAndSelectMessage(opToken, ktExpression3, leftIntValue, ktSingleValueToken, ktSingleValueToken2);
            } else if (this.isZeroOrNegative(rightIntValue)) {
                KtExpression ktExpression4 = bet.getLeft();
                KtSingleValueToken ktSingleValueToken = KtTokens.GTEQ;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "GTEQ");
                KtSingleValueToken ktSingleValueToken3 = KtTokens.LT;
                Intrinsics.checkNotNullExpressionValue(ktSingleValueToken3, "LT");
                string = this.checkConditionsAndSelectMessage(opToken, ktExpression4, rightIntValue, ktSingleValueToken, ktSingleValueToken3);
            } else {
                string = null;
            }
            String string2 = msg = string;
            if (string2 == null) break block4;
            String it = string2;
            boolean bl = false;
            AbstractCheck.reportIssue$default((AbstractCheck)this, fileCtx, (PsiElement)bet, it, null, null, 12, null);
        }
    }

    private final String checkConditionsAndSelectMessage(IElementType opToken, KtExpression testedExpr, Integer integerValue, KtSingleValueToken opWithEq, KtSingleValueToken opWithoutEq) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$checkConditionsAndSelectMessage_u24lambda_u242 = kaSession;
        boolean bl = false;
        if (testedExpr instanceof KtDotQualifiedExpression) {
            boolean bl2;
            block7: {
                Iterable $this$any$iv = CollectionSizeAndArrayLengthCheckKt.getMATCHERS();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FunMatcherImpl it = (FunMatcherImpl)element$iv;
                        boolean bl3 = false;
                        KaCallInfo kaCallInfo = $this$checkConditionsAndSelectMessage_u24lambda_u242.resolveToCall(testedExpr);
                        if (!it.matches(kaCallInfo != null ? KaCallInfoKt.singleVariableAccessCall(kaCallInfo) : null)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                if (Intrinsics.areEqual(opToken, opWithEq)) {
                    return CollectionSizeAndArrayLengthCheckKt.getISSUE_MESSAGE_SIZE_ALWAYS_GTEQ();
                }
                if (Intrinsics.areEqual(opToken, opWithoutEq) || this.isNegative(integerValue) && Intrinsics.areEqual(opToken, KtTokens.EQEQ)) {
                    return CollectionSizeAndArrayLengthCheckKt.getISSUE_MESSAGE_SIZE_NEVER_LT();
                }
            }
        }
        return null;
    }

    public final boolean isZeroOrNegative(@Nullable Integer $this$isZeroOrNegative) {
        return $this$isZeroOrNegative != null && $this$isZeroOrNegative <= 0;
    }

    public final boolean isNegative(@Nullable Integer $this$isNegative) {
        return $this$isNegative != null && $this$isNegative < 0;
    }
}

