/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1066")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/checks/CollapsibleIfStatementsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "getCollapsibleIfStatement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getIfStatementWithoutElse", "sonar-kotlin-checks"})
public final class CollapsibleIfStatementsCheck
extends AbstractCheck {
    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (expression.getElseKeyword() != null) {
            return;
        }
        KtExpression ktExpression = expression.getThen();
        Intrinsics.checkNotNull(ktExpression);
        KtIfExpression collapsibleIfStatement = this.getCollapsibleIfStatement(ktExpression);
        if (collapsibleIfStatement != null) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = expression.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
            Pair[] pairArray = new Pair[]{TuplesKt.to(collapsibleIfStatement.getIfKeyword(), "")};
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, "Merge this \"if\" statement with the nested one.", this.locationListOf(kotlinFileContext, pairArray), null, 8, null);
        }
    }

    private final KtIfExpression getCollapsibleIfStatement(KtExpression expression) {
        return expression instanceof KtBlockExpression ? (((KtBlockExpression)expression).getStatements().size() == 1 ? this.getIfStatementWithoutElse(((KtBlockExpression)expression).getFirstStatement()) : null) : this.getIfStatementWithoutElse(expression);
    }

    private final KtIfExpression getIfStatementWithoutElse(KtExpression expression) {
        return expression instanceof KtIfExpression && ((KtIfExpression)expression).getElseKeyword() == null ? (KtIfExpression)expression : null;
    }
}

