/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.CodeAfterJumpCheckKt;

@Rule(key="S1763")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/checks/CodeAfterJumpCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitBlockExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "checkStatements", "statementsOrExpressions", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "sonar-kotlin-checks"})
public final class CodeAfterJumpCheck
extends AbstractCheck {
    @Override
    public void visitBlockExpression(@NotNull KtBlockExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        List<KtExpression> list = expression.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        this.checkStatements(context, list);
    }

    private final void checkStatements(KotlinFileContext context, List<? extends KtElement> statementsOrExpressions) {
        int n2 = statementsOrExpressions.size() - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            String it;
            KtElement current = statementsOrExpressions.get(i2);
            if (CodeAfterJumpCheckKt.access$getJump(current) == null) continue;
            boolean bl = false;
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)current, "Refactor this piece of code to not have any dead code after this \"" + it + "\".", null, null, 12, null);
        }
    }
}

