/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.ClearTextProtocolCheckKt;
import org.sonarsource.kotlin.checks.OkHttpArgumentFinder;

@Rule(key="S5332")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u001a\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/sonarsource/kotlin/checks/ClearTextProtocolCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/Set;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "matchedFun", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "ctx", "checkAndroidMixedContentArgument", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "analyzeOkHttpCall", "callExpr", "sonar-kotlin-checks"})
public final class ClearTextProtocolCheck
extends CallAbstractCheck {
    @NotNull
    private final Set<FunMatcherImpl> functionsToVisit = SetsKt.plus(SetsKt.plus(ClearTextProtocolCheckKt.access$getUNSAFE_CALLS_GENERAL$p().keySet(), ClearTextProtocolCheckKt.access$getUNSAFE_CALLS_OK_HTTP$p()), (Iterable)CollectionsKt.listOf(ClearTextProtocolCheckKt.access$getANDROID_SET_MIXED_CONTENT_MODE$p()));

    @NotNull
    public Set<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitFunctionCall_u24lambda_u241 = kaSession;
        boolean bl = false;
        String string = (String)ClearTextProtocolCheckKt.access$getUNSAFE_CALLS_GENERAL$p().get(matchedFun);
        if (string != null) {
            String msg = string;
            boolean bl2 = false;
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)callExpression, msg, null, null, 12, null);
            return;
        }
        if (ClearTextProtocolCheckKt.access$getUNSAFE_CALLS_OK_HTTP$p().contains(matchedFun)) {
            this.analyzeOkHttpCall(kotlinFileContext, callExpression);
        } else if (Intrinsics.areEqual(matchedFun, ClearTextProtocolCheckKt.access$getANDROID_SET_MIXED_CONTENT_MODE$p())) {
            KaFunctionCall<?> kaFunctionCall;
            KaCallInfo kaCallInfo = $this$visitFunctionCall_u24lambda_u241.resolveToCall(callExpression);
            this.checkAndroidMixedContentArgument(kotlinFileContext, KtPsiUtil.deparenthesize(kaCallInfo != null && (kaFunctionCall = KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo)) != null ? ApiExtensionsKt.getFirstArgumentExpression(kaFunctionCall) : null));
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext ctx) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitBinaryExpression_u24lambda_u242 = kaSession;
        boolean bl = false;
        if (Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EQ)) {
            KaCallableMemberCall kaCallableMemberCall;
            FunMatcherImpl funMatcherImpl = ClearTextProtocolCheckKt.access$getANDROID_SET_MIXED_CONTENT_MODE$p();
            KaCallInfo kaCallInfo = $this$visitBinaryExpression_u24lambda_u242.resolveToCall(expression);
            if (kaCallInfo != null) {
                KaCallInfo $this$successfulCallOrNull$iv = kaCallInfo;
                boolean $i$f$successfulCallOrNull = false;
                KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
                KaCall kaCall = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
                if (!(kaCall instanceof KaCallableMemberCall)) {
                    kaCall = null;
                }
                kaCallableMemberCall = (KaCallableMemberCall)((KaCall)((KaCallableMemberCall)kaCall));
            } else {
                kaCallableMemberCall = null;
            }
            if (funMatcherImpl.matches(kaCallableMemberCall)) {
                this.checkAndroidMixedContentArgument(ctx, KtPsiUtil.deparenthesize(expression.getRight()));
            }
        }
    }

    private final void checkAndroidMixedContentArgument(KotlinFileContext ctx, KtExpression argument) {
        if (argument != null) {
            Integer n2 = ApiExtensionsKt.predictRuntimeIntValue(argument);
            if (n2 != null && n2 == 0) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)argument, "Using a relaxed mixed content policy is security-sensitive.", null, null, 12, null);
            }
        }
    }

    private final void analyzeOkHttpCall(KotlinFileContext kotlinFileContext, KtCallExpression callExpr) {
        new OkHttpArgumentFinder(arg_0 -> ClearTextProtocolCheck.analyzeOkHttpCall$lambda$3(this, kotlinFileContext, arg_0)).visitTree(callExpr);
    }

    private static final Unit analyzeOkHttpCall$lambda$3(ClearTextProtocolCheck this$0, KotlinFileContext $kotlinFileContext, KtSimpleNameExpression arg) {
        Intrinsics.checkNotNullParameter(arg, "arg");
        AbstractCheck.reportIssue$default((AbstractCheck)this$0, $kotlinFileContext, (PsiElement)arg, ClearTextProtocolCheckKt.access$msg("HTTP", "HTTPS"), null, null, 12, null);
        return Unit.INSTANCE;
    }
}

