/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\u001a$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0002\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"CIPHER_INIT_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "GCM_PARAMETER_SPEC_MATCHER", "GET_BYTES_MATCHER", "generateSecondaryLocations", "", "Lorg/sonarsource/kotlin/api/reporting/SecondaryLocation;", "secondaries", "Lcom/intellij/psi/PsiElement;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "getByteExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "getGCMExpression", "sonar-kotlin-checks"})
public final class CipherModeOperationCheckKt {
    @NotNull
    private static final FunMatcherImpl CIPHER_INIT_MATCHER = FunMatcherKt.FunMatcher$default("javax.crypto.Cipher", "init", null, null, false, null, null, null, null, null, CipherModeOperationCheckKt::CIPHER_INIT_MATCHER$lambda$0, 1020, null);
    @NotNull
    private static final FunMatcherImpl GCM_PARAMETER_SPEC_MATCHER = FunMatcherKt.ConstructorMatcher("javax.crypto.spec.GCMParameterSpec", CipherModeOperationCheckKt::GCM_PARAMETER_SPEC_MATCHER$lambda$1);
    @NotNull
    private static final FunMatcherImpl GET_BYTES_MATCHER = FunMatcherKt.FunMatcher$default("kotlin.text", "toByteArray", null, null, false, null, null, null, null, null, null, 2044, null);

    /*
     * WARNING - void declaration
     */
    private static final List<SecondaryLocation> generateSecondaryLocations(List<? extends PsiElement> secondaries, KotlinFileContext kotlinFileContext) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = secondaries;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void secondary;
            void i2;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PsiElement psiElement = (PsiElement)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(i2 < secondaries.size() - 1 ? new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, (PsiElement)secondary), "Initialization vector is configured here.") : new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, (PsiElement)secondary), "The initialization vector is a static value."));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final KtExpression getByteExpression(KtExpression $this$getByteExpression, List<PsiElement> secondaries) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$getByteExpression_u24lambda_u245 = kaSession;
        boolean bl = false;
        KtExpression $this$getByteExpression_u24lambda_u245_u24lambda_u244 = ApiExtensionsKt.predictRuntimeValueExpression($this$getByteExpression, secondaries);
        boolean bl2 = false;
        KaCallInfo kaCallInfo = $this$getByteExpression_u24lambda_u245.resolveToCall($this$getByteExpression_u24lambda_u245_u24lambda_u244);
        KaLifetimeOwner kaLifetimeOwner = kaCallInfo;
        if (kaCallInfo == null) return null;
        KaCallInfo $this$successfulCallOrNull$iv = kaLifetimeOwner;
        boolean bl3 = false;
        KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
        KaCall kaCall = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
        if (!(kaCall instanceof KaCallableMemberCall)) {
            kaCall = null;
        }
        KaCallableMemberCall kaCallableMemberCall = (KaCallableMemberCall)((KaCall)((KaCallableMemberCall)kaCall));
        kaLifetimeOwner = kaCallableMemberCall;
        if (kaCallableMemberCall == null) return null;
        KaLifetimeOwner kaLifetimeOwner2 = kaLifetimeOwner;
        boolean bl4 = false;
        if (!GET_BYTES_MATCHER.matches((KaCallableMemberCall<?, ?>)kaLifetimeOwner2)) return null;
        KtExpression ktExpression = $this$getByteExpression_u24lambda_u245_u24lambda_u244;
        return ktExpression;
    }

    private static final KtExpression getGCMExpression(KtExpression $this$getGCMExpression, List<PsiElement> secondaries) {
        KtExpression ktExpression;
        KaFunctionCall<?> kaFunctionCall;
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$getGCMExpression_u24lambda_u247 = kaSession;
        boolean bl = false;
        KaCallInfo kaCallInfo = $this$getGCMExpression_u24lambda_u247.resolveToCall(ApiExtensionsKt.predictRuntimeValueExpression$default($this$getGCMExpression, null, 1, null));
        if (kaCallInfo != null && (kaFunctionCall = KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo)) != null) {
            KaFunctionCall<?> it = kaFunctionCall;
            boolean bl2 = false;
            if (GCM_PARAMETER_SPEC_MATCHER.matches((KaCallableMemberCall)it)) {
                KtExpression argumentExpression = (KtExpression)CollectionsKt.elementAt((Iterable)it.getArgumentMapping().keySet(), 1);
                secondaries.add(argumentExpression);
                ktExpression = argumentExpression;
            } else {
                ktExpression = null;
            }
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    private static final Unit CIPHER_INIT_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Int", "java.security.Key", "java.security.spec.AlgorithmParameterSpec"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit GCM_PARAMETER_SPEC_MATCHER$lambda$1(FunMatcherBuilderContext $this$ConstructorMatcher) {
        Intrinsics.checkNotNullParameter($this$ConstructorMatcher, "$this$ConstructorMatcher");
        String[] stringArray = new String[]{"kotlin.Int", "kotlin.ByteArray"};
        $this$ConstructorMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FunMatcherImpl access$getCIPHER_INIT_MATCHER$p() {
        return CIPHER_INIT_MATCHER;
    }

    public static final /* synthetic */ KtExpression access$getGCMExpression(KtExpression $receiver, List secondaries) {
        return CipherModeOperationCheckKt.getGCMExpression($receiver, secondaries);
    }

    public static final /* synthetic */ KtExpression access$getByteExpression(KtExpression $receiver, List secondaries) {
        return CipherModeOperationCheckKt.getByteExpression($receiver, secondaries);
    }

    public static final /* synthetic */ List access$generateSecondaryLocations(List secondaries, KotlinFileContext kotlinFileContext) {
        return CipherModeOperationCheckKt.generateSecondaryLocations(secondaries, kotlinFileContext);
    }
}

