/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1125")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J'\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u0011\"\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/BooleanLiteralCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "getBooleanLiteral", "Lorg/jetbrains/kotlin/psi/KtExpression;", "trees", "", "([Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "sonar-kotlin-checks"})
public final class BooleanLiteralCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<KtSingleValueToken> CONDITIONAL_BINARY_OPERATORS;
    @NotNull
    private static final Set<String> BOOLEAN_LITERALS;
    @NotNull
    private static final String MESSAGE = "Remove the unnecessary Boolean literal.";

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression, @NotNull KotlinFileContext context) {
        block0: {
            KtExpression[] ktExpressionArray;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!BooleanLiteralCheck.Companion.isIfWithMaxTwoBranches(expression) || BooleanLiteralCheck.Companion.hasBlockBranch(expression) || (ktExpression = this.getBooleanLiteral(ktExpressionArray = new KtExpression[]{expression.getThen(), expression.getElse()})) == null) break block0;
            KtExpression it = ktExpression;
            boolean bl = false;
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)it, MESSAGE, null, null, 12, null);
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext context) {
        block1: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!CollectionsKt.contains((Iterable)CONDITIONAL_BINARY_OPERATORS, expression.getOperationToken())) break block1;
            KtExpression[] ktExpressionArray = new KtExpression[]{expression.getLeft(), expression.getRight()};
            KtExpression ktExpression = this.getBooleanLiteral(ktExpressionArray);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)it, MESSAGE, null, null, 12, null);
            }
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression expression, @NotNull KotlinFileContext context) {
        block1: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!Intrinsics.areEqual(KtTokens.EXCL, expression.getOperationToken())) break block1;
            KtExpression[] ktExpressionArray = new KtExpression[]{expression.getBaseExpression()};
            KtExpression ktExpression = this.getBooleanLiteral(ktExpressionArray);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)it, MESSAGE, null, null, 12, null);
            }
        }
    }

    private final KtExpression getBooleanLiteral(KtExpression ... trees) {
        KtExpression ktExpression;
        block1: {
            Sequence<KtExpression> sequence2 = SequencesKt.mapNotNull(ArraysKt.asSequence(trees), arg_0 -> BooleanLiteralCheck.getBooleanLiteral$lambda$3(this, arg_0));
            Iterator<KtExpression> iterator2 = sequence2.iterator();
            while (iterator2.hasNext()) {
                KtExpression ktExpression2;
                KtExpression it = ktExpression2 = iterator2.next();
                boolean bl = false;
                if (!(it instanceof KtConstantExpression && BOOLEAN_LITERALS.contains(((KtConstantExpression)it).getText()))) continue;
                ktExpression = ktExpression2;
                break block1;
            }
            ktExpression = null;
        }
        return ktExpression;
    }

    private static final KtExpression getBooleanLiteral$lambda$3(BooleanLiteralCheck this$0, KtExpression it) {
        KtExpression ktExpression = it;
        return ktExpression != null ? this$0.skipParentheses(ktExpression) : null;
    }

    static {
        Object[] objectArray = new KtSingleValueToken[]{KtTokens.ANDAND, KtTokens.OROR};
        CONDITIONAL_BINARY_OPERATORS = SetsKt.setOf(objectArray);
        objectArray = new String[]{"true", "false"};
        BOOLEAN_LITERALS = SetsKt.setOf(objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/BooleanLiteralCheck$Companion;", "", "<init>", "()V", "CONDITIONAL_BINARY_OPERATORS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "BOOLEAN_LITERALS", "", "MESSAGE", "isIfWithMaxTwoBranches", "", "ifTree", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "hasBlockBranch", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isIfWithMaxTwoBranches(KtIfExpression ifTree) {
            PsiElement grandParent = ifTree.getParent().getParent();
            boolean isElseIf = grandParent instanceof KtIfExpression && ((KtIfExpression)grandParent).getElse() == ifTree;
            boolean isIfElseIf = ifTree.getElse() instanceof KtIfExpression;
            return !isElseIf && !isIfElseIf;
        }

        private final boolean hasBlockBranch(KtIfExpression ifTree) {
            return ifTree.getThen() instanceof KtBlockExpression || ifTree.getElse() instanceof KtBlockExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

