/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1940")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/sonarsource/kotlin/checks/BooleanInversionCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitUnaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "Companion", "sonar-kotlin-checks"})
public final class BooleanInversionCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<KtSingleValueToken, String> OPERATORS;

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EXCL)) {
            return;
        }
        KtExpression ktExpression = expression.getBaseExpression();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression innerExpression = this.skipParentheses(ktExpression);
        if (innerExpression instanceof KtBinaryExpression) {
            String oppositeOperator = OPERATORS.get(((KtBinaryExpression)innerExpression).getOperationToken());
            if (oppositeOperator != null) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)expression, "Use the opposite operator (\"" + oppositeOperator + "\") instead.", null, null, 12, null);
            }
        } else if (innerExpression instanceof KtIsExpression) {
            String oppositeOperator = ((KtIsExpression)innerExpression).isNegated() ? "is" : "!is";
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)expression, "Use the opposite operator (\"" + oppositeOperator + "\") instead.", null, null, 12, null);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(KtTokens.EQEQ, "!="), TuplesKt.to(KtTokens.EXCLEQ, "=="), TuplesKt.to(KtTokens.EQEQEQ, "!=="), TuplesKt.to(KtTokens.EXCLEQEQEQ, "==="), TuplesKt.to(KtTokens.LT, ">="), TuplesKt.to(KtTokens.GT, "<="), TuplesKt.to(KtTokens.LTEQ, ">"), TuplesKt.to(KtTokens.GTEQ, "<")};
        OPERATORS = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\u0016\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/BooleanInversionCheck$Companion;", "", "<init>", "()V", "OPERATORS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

