/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.AndroidBroadcastingCheckKt;

@Rule(key="S5320")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J\u001e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/sonarsource/kotlin/checks/AndroidBroadcastingCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "isSendOrderedBroadcastAsUser", "", "name", "", "argumentsByIndex", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isSendOrderedBroadcast", "isSendBroadcastAsUser", "isSendBroadcast", "sonar-kotlin-checks"})
public final class AndroidBroadcastingCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(FunMatcherKt.FunMatcher$default(null, null, null, "android.content.Context", false, null, null, null, null, null, AndroidBroadcastingCheck::functionsToVisit$lambda$0, 1015, null));

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List arguments2 = CollectionsKt.toList((Iterable)resolvedCall2.getArgumentMapping().keySet());
        Object object = KaSymbolKt.getName((KaSymbol)KaPartiallyAppliedSymbolKt.getSymbol(resolvedCall2.getPartiallyAppliedSymbol()));
        if (object == null || (object = ((Name)object).asString()) == null) {
            return;
        }
        Object name = object;
        if (AndroidBroadcastingCheckKt.access$getSTICKY_BROADCAST_NAMES$p().contains(name) || this.isSendBroadcast((String)name, arguments2) || this.isSendBroadcastAsUser((String)name, arguments2) || this.isSendOrderedBroadcast((String)name, arguments2) || this.isSendOrderedBroadcastAsUser((String)name, arguments2)) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Make sure that broadcasting intents is safe here.", null, null, 12, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendOrderedBroadcastAsUser(String name, List<? extends KtExpression> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendOrderedBroadcastAsUser")) return false;
        KtExpression ktExpression = CollectionsKt.getOrNull(argumentsByIndex, 2);
        if (ktExpression == null) return false;
        boolean bl = ApiExtensionsKt.isPredictedNull(ktExpression);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendOrderedBroadcast(String name, List<? extends KtExpression> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendOrderedBroadcast")) return false;
        KtExpression ktExpression = CollectionsKt.getOrNull(argumentsByIndex, 1);
        if (ktExpression == null) return false;
        boolean bl = ApiExtensionsKt.isPredictedNull(ktExpression);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendBroadcastAsUser(String name, List<? extends KtExpression> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendBroadcast")) return false;
        KtExpression ktExpression = CollectionsKt.getOrNull(argumentsByIndex, 1);
        if (ktExpression == null) return true;
        boolean bl = ApiExtensionsKt.isPredictedNull(ktExpression);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSendBroadcast(String name, List<? extends KtExpression> argumentsByIndex) {
        if (!Intrinsics.areEqual(name, "sendBroadcastAsUser")) return false;
        KtExpression ktExpression = CollectionsKt.getOrNull(argumentsByIndex, 2);
        if (ktExpression == null) return true;
        boolean bl = ApiExtensionsKt.isPredictedNull(ktExpression);
        if (!bl) return false;
        return true;
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"sendBroadcast", "sendBroadcastAsUser", "sendOrderedBroadcast", "sendOrderedBroadcastAsUser", "sendStickyBroadcast", "sendStickyBroadcastAsUser", "sendStickyOrderedBroadcast", "sendStickyOrderedBroadcastAsUser"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }
}

