/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u001c\u0010\u001e\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0002J,\u0010\"\u001a\u00020\u000f*\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u000e\u0010'\u001a\u0004\u0018\u00010\u0005*\u00020(H\u0002J(\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010.\u001a\u00020\u0005H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/sonarsource/kotlin/checks/AbstractHardcodedVisitor;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "sensitiveVariableKind", "", "getSensitiveVariableKind", "()Ljava/lang/String;", "sensitiveWords", "getSensitiveWords", "variablePatterns", "Lkotlin/sequences/Sequence;", "Lkotlin/text/Regex;", "literalPatterns", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "isSensitive", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "isSensitiveStringLiteral", "value", "report", "tree", "Lcom/intellij/psi/PsiElement;", "matchName", "checkAssignedValue", "matchResult", "Lkotlin/text/MatchResult;", "regex", "leftHand", "identifier", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkVariable", "ctx", "variable", "variableName", "toPatterns", "suffix", "Companion", "sonar-kotlin-checks"})
public abstract class AbstractHardcodedVisitor
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Sequence<Regex> variablePatterns;
    @Nullable
    private Sequence<Regex> literalPatterns;

    @NotNull
    public abstract String getSensitiveVariableKind();

    @NotNull
    public abstract String getSensitiveWords();

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext context) {
        block1: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EQ) && !Intrinsics.areEqual(expression.getOperationToken(), KtTokens.PLUSEQ)) break block1;
            KtExpression left = expression.getLeft();
            Object object = left;
            if (object != null && (object = this.identifier((KtExpression)object)) != null) {
                Object it = object;
                boolean bl = false;
                PsiElement psiElement = left;
                KtExpression ktExpression = expression.getRight();
                Intrinsics.checkNotNull(ktExpression);
                this.checkVariable(context, psiElement, (String)it, ktExpression);
            }
        }
    }

    @Override
    public void visitProperty(@NotNull KtProperty property, @NotNull KotlinFileContext context) {
        block0: {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(context, "context");
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression == null) break block0;
            KtExpression it = ktExpression;
            boolean bl = false;
            PsiElement psiElement = property.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            String string = property.getName();
            Intrinsics.checkNotNull(string);
            this.checkVariable(context, psiElement, string, it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, @NotNull KotlinFileContext context) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        String content = !expression.hasInterpolation() ? this.asConstant(expression) : "";
        Sequence<String> sequence2 = SequencesKt.filter(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(SequencesKt.mapNotNull(this.literalPatterns(), arg_0 -> AbstractHardcodedVisitor.visitStringTemplateExpression$lambda$2(content, arg_0)), AbstractHardcodedVisitor::visitStringTemplateExpression$lambda$3), arg_0 -> AbstractHardcodedVisitor.visitStringTemplateExpression$lambda$4(this, arg_0)), AbstractHardcodedVisitor::visitStringTemplateExpression$lambda$5), arg_0 -> AbstractHardcodedVisitor.visitStringTemplateExpression$lambda$6(content, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String credential = (String)element$iv;
            boolean bl = false;
            this.report(context, expression, credential);
        }
    }

    private final boolean isSensitive(KtElement $this$isSensitive) {
        return $this$isSensitive instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)$this$isSensitive).hasInterpolation() && this.isSensitiveStringLiteral(this.asConstant((KtStringTemplateExpression)$this$isSensitive));
    }

    public boolean isSensitiveStringLiteral(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return ((CharSequence)value2).length() > 0;
    }

    private final void report(KotlinFileContext $this$report, PsiElement tree, String matchName) {
        AbstractCheck.reportIssue$default((AbstractCheck)this, $this$report, tree, "\"" + matchName + "\" detected here, make sure this is not a hard-coded " + this.getSensitiveVariableKind() + ".", null, null, 12, null);
    }

    private final void checkAssignedValue(KotlinFileContext $this$checkAssignedValue, MatchResult matchResult, Regex regex, PsiElement leftHand, String value2) {
        if (!regex.containsMatchIn(value2)) {
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            Intrinsics.checkNotNull(matchGroup);
            this.report($this$checkAssignedValue, leftHand, matchGroup.getValue());
        }
    }

    private final String identifier(KtExpression $this$identifier) {
        String string;
        KtExpression ktExpression = $this$identifier;
        if (ktExpression instanceof KtNameReferenceExpression) {
            string = ((KtNameReferenceExpression)$this$identifier).getReferencedName();
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression2 = ((KtDotQualifiedExpression)$this$identifier).getSelectorExpression();
            string = ktExpression2 != null ? this.identifier(ktExpression2) : null;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVariable(KotlinFileContext ctx, PsiElement variable, String variableName, KtElement value2) {
        if (this.isSensitive(value2)) {
            void $this$forEach$iv;
            Sequence<Pair> sequence2 = SequencesKt.mapNotNull(this.variablePatterns(), arg_0 -> AbstractHardcodedVisitor.checkVariable$lambda$9(variableName, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                MatchResult matcher = (MatchResult)pair.component1();
                Regex regex = (Regex)pair.component2();
                Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
                this.checkAssignedValue(ctx, matcher, regex, variable, this.asConstant((KtStringTemplateExpression)value2));
            }
        }
    }

    private final Sequence<Regex> variablePatterns() {
        Sequence<Regex> sequence2 = this.variablePatterns;
        if (sequence2 == null) {
            Sequence<Regex> sequence3;
            Sequence<Regex> it = sequence3 = this.toPatterns("");
            boolean bl = false;
            this.variablePatterns = it;
            sequence2 = sequence3;
        }
        return sequence2;
    }

    private final Sequence<Regex> literalPatterns() {
        Sequence<Regex> sequence2 = this.literalPatterns;
        if (sequence2 == null) {
            Sequence<Regex> sequence3;
            Sequence<Regex> it = sequence3 = this.toPatterns("=([^\\s&]+)");
            boolean bl = false;
            this.literalPatterns = it;
            sequence2 = sequence3;
        }
        return sequence2;
    }

    private final Sequence<Regex> toPatterns(String suffix) {
        String[] stringArray = new String[]{","};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.getSensitiveWords(), stringArray, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return SequencesKt.map(SequencesKt.map(ArraysKt.asSequence(thisCollection$iv.toArray(new String[0])), AbstractHardcodedVisitor::toPatterns$lambda$14), arg_0 -> AbstractHardcodedVisitor.toPatterns$lambda$15(suffix, arg_0));
    }

    private static final MatchResult visitStringTemplateExpression$lambda$2(String $content, Regex regex) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        return Regex.find$default(regex, $content, 0, 2, null);
    }

    private static final boolean visitStringTemplateExpression$lambda$3(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        return matchResult.getGroups().size() > 2;
    }

    private static final boolean visitStringTemplateExpression$lambda$4(AbstractHardcodedVisitor this$0, MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        MatchGroup matchGroup = matchResult.getGroups().get(2);
        Intrinsics.checkNotNull(matchGroup);
        return this$0.isSensitiveStringLiteral(matchGroup.getValue());
    }

    private static final String visitStringTemplateExpression$lambda$5(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        MatchGroup matchGroup = matchResult.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup);
        return matchGroup.getValue();
    }

    private static final boolean visitStringTemplateExpression$lambda$6(String $content, String match) {
        Intrinsics.checkNotNullParameter(match, "match");
        return !AbstractHardcodedVisitor.Companion.isQuery($content, match);
    }

    private static final Pair checkVariable$lambda$9(String $variableName, Regex regex) {
        Pair<MatchResult, Regex> pair;
        Intrinsics.checkNotNullParameter(regex, "regex");
        MatchResult matchResult = Regex.find$default(regex, $variableName, 0, 2, null);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            pair = TuplesKt.to(it, regex);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final String toPatterns$lambda$14(String obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        String $this$trim$iv = obj;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    private static final Regex toPatterns$lambda$15(String $suffix, String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        return new Regex("(" + word + ")" + $suffix, RegexOption.IGNORE_CASE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/AbstractHardcodedVisitor$Companion;", "", "<init>", "()V", "isQuery", "", "value", "", "match", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isQuery(String value2, String match) {
            String string = value2.substring(StringsKt.indexOf$default((CharSequence)value2, match, 0, false, 6, null) + match.length());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String followingString = string;
            return StringsKt.startsWith$default(followingString, "=?", false, 2, null) || StringsKt.startsWith$default(followingString, "=%", false, 2, null) || StringsKt.startsWith$default(followingString, "=:", false, 2, null) || StringsKt.startsWith$default(followingString, "={", false, 2, null) || Intrinsics.areEqual(followingString, "='");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

