/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.reporting;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ*\u0010\u0004\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0086\u0002J\u0018\u0010\u0017\u001a\u00020\u0005*\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\u0018\u0010\u0017\u001a\u00020\u0005*\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019\u00a8\u0006\u001a"}, d2={"Lorg/sonarsource/kotlin/api/reporting/KotlinTextRanges;", "", "<init>", "()V", "textRange", "Lorg/sonar/api/batch/fs/TextRange;", "Lorg/sonar/api/batch/fs/InputFile;", "psiDocument", "Lcom/intellij/openapi/editor/Document;", "element", "Lcom/intellij/psi/PsiElement;", "startOffset", "", "endOffset", "textPointerAtOffset", "Lorg/sonar/api/batch/fs/TextPointer;", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "psiElement", "startLine", "endLine", "contains", "", "other", "merge", "ranges", "", "sonar-kotlin-api"})
public final class KotlinTextRanges {
    @NotNull
    public static final KotlinTextRanges INSTANCE = new KotlinTextRanges();

    private KotlinTextRanges() {
    }

    @NotNull
    public final TextRange textRange(@NotNull InputFile $this$textRange, @NotNull Document psiDocument, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        Intrinsics.checkNotNullParameter(psiDocument, "psiDocument");
        Intrinsics.checkNotNullParameter(element, "element");
        return this.textRange($this$textRange, psiDocument, element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
    }

    @NotNull
    public final TextRange textRange(@NotNull InputFile $this$textRange, @NotNull Document psiDocument, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        Intrinsics.checkNotNullParameter(psiDocument, "psiDocument");
        TextPointer startPointer = this.textPointerAtOffset($this$textRange, psiDocument, startOffset);
        TextPointer endPointer = this.textPointerAtOffset($this$textRange, psiDocument, endOffset);
        TextRange textRange = $this$textRange.newRange(startPointer.line(), startPointer.lineOffset(), endPointer.line(), endPointer.lineOffset());
        Intrinsics.checkNotNullExpressionValue(textRange, "newRange(...)");
        return textRange;
    }

    @NotNull
    public final TextPointer textPointerAtOffset(@NotNull InputFile $this$textPointerAtOffset, @NotNull Document psiDocument, int startOffset) {
        Intrinsics.checkNotNullParameter($this$textPointerAtOffset, "<this>");
        Intrinsics.checkNotNullParameter(psiDocument, "psiDocument");
        int startLineNumber = psiDocument.getLineNumber(startOffset);
        int startLineNumberOffset = psiDocument.getLineStartOffset(startLineNumber);
        int startLineOffset = startOffset - startLineNumberOffset;
        TextPointer textPointer = $this$textPointerAtOffset.newPointer(startLineNumber + 1, startLineOffset);
        Intrinsics.checkNotNullExpressionValue(textPointer, "newPointer(...)");
        return textPointer;
    }

    @NotNull
    public final TextRange textRange(@NotNull KotlinFileContext $this$textRange, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        InputFile inputFile = $this$textRange.getInputFileContext().getInputFile();
        Document document = $this$textRange.getKtFile().getViewProvider().getDocument();
        Intrinsics.checkNotNull(document);
        return this.textRange(inputFile, document, startOffset, endOffset);
    }

    @NotNull
    public final TextRange textRange(@NotNull KotlinFileContext $this$textRange, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        InputFile inputFile = $this$textRange.getInputFileContext().getInputFile();
        Document document = $this$textRange.getKtFile().getViewProvider().getDocument();
        Intrinsics.checkNotNull(document);
        return this.textRange(inputFile, document, psiElement);
    }

    @NotNull
    public final TextRange textRange(@NotNull KotlinFileContext $this$textRange, int startLine, int startOffset, int endLine, int endOffset) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        TextRange textRange = $this$textRange.getInputFileContext().getInputFile().newRange(startLine, startOffset, endLine, endOffset);
        Intrinsics.checkNotNullExpressionValue(textRange, "newRange(...)");
        return textRange;
    }

    public final boolean contains(@NotNull TextRange $this$contains, @NotNull TextRange other) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return $this$contains.start().compareTo((Object)other.start()) <= 0 && $this$contains.end().compareTo((Object)other.end()) >= 0;
    }

    @NotNull
    public final TextRange merge(@NotNull InputFile $this$merge, @NotNull Iterable<? extends TextRange> ranges) {
        Collection<TextPointer> collection;
        TextRange it;
        boolean bl;
        Collection collection2;
        Iterable<? extends TextRange> $this$mapTo$iv$iv;
        Iterable<? extends TextRange> $this$map$iv;
        Intrinsics.checkNotNullParameter($this$merge, "<this>");
        Intrinsics.checkNotNullParameter(ranges, "ranges");
        Iterable<? extends TextRange> iterable = ranges;
        InputFile inputFile = $this$merge;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t2 : $this$mapTo$iv$iv) {
            TextRange textRange = (TextRange)t2;
            collection2 = destination$iv$iv;
            bl = false;
            collection2.add(it.start());
        }
        TextPointer textPointer = (TextPointer)CollectionsKt.minOrNull((List)destination$iv$iv);
        if (textPointer == null) {
            throw new IllegalArgumentException("Can't merge 0 ranges");
        }
        $this$map$iv = ranges;
        collection2 = textPointer;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object object : $this$mapTo$iv$iv) {
            it = (TextRange)object;
            collection = destination$iv$iv;
            bl = false;
            collection.add(it.end());
        }
        collection = (List)destination$iv$iv;
        TextPointer textPointer2 = (TextPointer)CollectionsKt.maxOrNull((Iterable)collection);
        if (textPointer2 == null) {
            throw new IllegalArgumentException("Can't merge 0 ranges");
        }
        TextRange textRange = inputFile.newRange((TextPointer)collection2, textPointer2);
        Intrinsics.checkNotNullExpressionValue(textRange, "newRange(...)");
        return textRange;
    }

    @NotNull
    public final TextRange merge(@NotNull KotlinFileContext $this$merge, @NotNull Iterable<? extends TextRange> ranges) {
        Intrinsics.checkNotNullParameter($this$merge, "<this>");
        Intrinsics.checkNotNullParameter(ranges, "ranges");
        return this.merge($this$merge.getInputFileContext().getInputFile(), ranges);
    }
}

