/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.frontend;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.kotlin.api.frontend.KotlinAnalyzerRegexSourceKt;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0093\u0001\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012`\u0010\t\u001a\\\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J*\u0010\u0013\u001a\u001e\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00050\u00050\u00142\u0006\u0010\u0016\u001a\u00020\u0004J*\u0010\u0017\u001a\u001e\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00050\u00050\u00142\u0006\u0010\u0016\u001a\u00020\u0004J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ/\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fH\u0086\u0010R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rh\u0010\t\u001a\\\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/sonarsource/kotlin/api/frontend/TextRangeTracker;", "", "regexIndexToTextRange", "Ljava/util/NavigableMap;", "", "Lorg/sonar/api/batch/fs/TextRange;", "textRangeToKtNode", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "textRange", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "startLine", "startColumn", "endLine", "endColumn", "<init>", "(Ljava/util/NavigableMap;Ljava/util/Map;Lkotlin/jvm/functions/Function4;)V", "rangeAtIndex", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "index", "rangeBeforeIndex", "textRangesBetween", "", "range", "Lorg/sonarsource/analyzer/commons/regex/ast/IndexRange;", "startIndex", "endIndex", "acc", "", "Companion", "sonar-kotlin-api"})
public final class TextRangeTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NavigableMap<Integer, TextRange> regexIndexToTextRange;
    @NotNull
    private final Map<TextRange, KtStringTemplateEntry> textRangeToKtNode;
    @NotNull
    private final Function4<Integer, Integer, Integer, Integer, TextRange> textRange;

    private TextRangeTracker(NavigableMap<Integer, TextRange> regexIndexToTextRange, Map<TextRange, ? extends KtStringTemplateEntry> textRangeToKtNode, Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, ? extends TextRange> textRange) {
        this.regexIndexToTextRange = regexIndexToTextRange;
        this.textRangeToKtNode = textRangeToKtNode;
        this.textRange = textRange;
    }

    @NotNull
    public final Pair<Integer, TextRange> rangeAtIndex(int index2) {
        Map.Entry<Integer, TextRange> entry = this.regexIndexToTextRange.floorEntry(index2);
        Intrinsics.checkNotNullExpressionValue(entry, "floorEntry(...)");
        Map.Entry<Integer, TextRange> entry2 = entry;
        return new Pair<Integer, TextRange>(entry2.getKey(), entry2.getValue());
    }

    @NotNull
    public final Pair<Integer, TextRange> rangeBeforeIndex(int index2) {
        Map.Entry<Integer, TextRange> entry = this.regexIndexToTextRange.lowerEntry(index2);
        Intrinsics.checkNotNullExpressionValue(entry, "lowerEntry(...)");
        Map.Entry<Integer, TextRange> entry2 = entry;
        return new Pair<Integer, TextRange>(entry2.getKey(), entry2.getValue());
    }

    @NotNull
    public final Collection<TextRange> textRangesBetween(@NotNull IndexRange range) {
        Intrinsics.checkNotNullParameter(range, "range");
        return TextRangeTracker.textRangesBetween$default(this, range.getBeginningOffset(), range.getEndingOffset(), null, 4, null);
    }

    @NotNull
    public final Collection<TextRange> textRangesBetween(int startIndex, int endIndex, @NotNull List<TextRange> acc) {
        int endOffset;
        int startOffset;
        TextRange start;
        Intrinsics.checkNotNullParameter(acc, "acc");
        TextRangeTracker textRangeTracker = this;
        while (true) {
            List<TextRange> list;
            if (startIndex >= endIndex) {
                return CollectionsKt.emptyList();
            }
            Pair<Integer, TextRange> pair = startIndex < 0 ? textRangeTracker.rangeAtIndex(0) : textRangeTracker.rangeAtIndex(startIndex);
            Integer startRangeIndex = pair.component1();
            start = pair.component2();
            Intrinsics.checkNotNull(startRangeIndex);
            startOffset = startIndex - startRangeIndex;
            Pair<Integer, TextRange> pair2 = endIndex > 0 ? textRangeTracker.rangeBeforeIndex(endIndex) : TuplesKt.to(startRangeIndex, start);
            Integer endRangeIndex = pair2.component1();
            TextRange end = pair2.component2();
            Intrinsics.checkNotNull(endRangeIndex);
            endOffset = endIndex - endRangeIndex;
            if (Intrinsics.areEqual(start, end)) break;
            TextRangeTracker textRangeTracker2 = textRangeTracker;
            Integer n2 = textRangeTracker.regexIndexToTextRange.higherKey(startRangeIndex);
            Intrinsics.checkNotNullExpressionValue(n2, "higherKey(...)");
            int n3 = ((Number)n2).intValue();
            int n4 = endIndex;
            List<TextRange> $this$textRangesBetween_u24lambda_u240 = list = acc;
            boolean bl = false;
            $this$textRangesBetween_u24lambda_u240.add(textRangeTracker.textRange.invoke(start.start().line(), start.start().lineOffset() + startOffset, start.end().line(), start.end().lineOffset()));
            List<TextRange> list2 = list;
            textRangeTracker = textRangeTracker2;
            startIndex = n3;
            endIndex = n4;
            acc = list2;
        }
        return CollectionsKt.plus((Collection)acc, textRangeTracker.textRange.invoke(start.start().line(), start.start().lineOffset() + startOffset, start.end().line(), start.start().lineOffset() + endOffset));
    }

    public static /* synthetic */ Collection textRangesBetween$default(TextRangeTracker textRangeTracker, int n2, int n3, List list, int n4, Object object) {
        if ((n4 & 4) != 0) {
            list = new ArrayList();
        }
        return textRangeTracker.textRangesBetween(n2, n3, list);
    }

    public /* synthetic */ TextRangeTracker(NavigableMap regexIndexToTextRange, Map textRangeToKtNode, Function4 textRange, DefaultConstructorMarker $constructor_marker) {
        this(regexIndexToTextRange, textRangeToKtNode, textRange);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/api/frontend/TextRangeTracker$Companion;", "", "<init>", "()V", "of", "Lorg/sonarsource/kotlin/api/frontend/TextRangeTracker;", "stringTemplateEntries", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "document", "Lcom/intellij/openapi/editor/Document;", "sonar-kotlin-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TextRangeTracker of(@NotNull Iterable<? extends KtStringTemplateEntry> stringTemplateEntries, @NotNull InputFile inputFile, @NotNull Document document) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter(stringTemplateEntries, "stringTemplateEntries");
            Intrinsics.checkNotNullParameter(inputFile, "inputFile");
            Intrinsics.checkNotNullParameter(document, "document");
            int endIndex = 0;
            TreeMap regexIndexToTextRange = new TreeMap();
            Iterable<? extends KtStringTemplateEntry> iterable = stringTemplateEntries;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            void var10_9 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void entry;
                KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                TextRange textRange = KotlinTextRanges.INSTANCE.textRange(inputFile, document, (PsiElement)entry);
                ((Map)regexIndexToTextRange).put(endIndex, textRange);
                endIndex += KotlinAnalyzerRegexSourceKt.isUnescapedEscapeChar((KtStringTemplateEntry)entry) ? 2 : entry.getTextLength();
                map2.put(textRange, element$iv$iv);
            }
            Map textRangeToKtNode = destination$iv$iv;
            return new TextRangeTracker(regexIndexToTextRange, textRangeToKtNode, (arg_0, arg_1, arg_2, arg_3) -> Companion.of$lambda$1(inputFile, arg_0, arg_1, arg_2, arg_3), null);
        }

        private static final TextRange of$lambda$1(InputFile $inputFile, int startLine, int startColumn, int endLine, int endColumn) {
            TextRange textRange = $inputFile.newRange(startLine, startColumn, endLine, endColumn);
            Intrinsics.checkNotNullExpressionValue(textRange, "newRange(...)");
            return textRange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

