/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.frontend;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonarsource.kotlin.api.frontend.KotlinFileSystem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0016J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/sonarsource/kotlin/api/frontend/KotlinVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileSystem", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileSystem;", "file", "Ljava/io/File;", "contentProvider", "Lkotlin/Function0;", "", "<init>", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileSystem;Ljava/io/File;Lkotlin/jvm/functions/Function0;)V", "getName", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "isWritable", "", "isDirectory", "isValid", "getParent", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getOutputStream", "Ljava/io/OutputStream;", "p0", "", "p1", "", "p2", "contentsToByteArray", "", "getTimeStamp", "getLength", "refresh", "", "Ljava/lang/Runnable;", "getInputStream", "Ljava/io/InputStream;", "sonar-kotlin-api"})
public final class KotlinVirtualFile
extends VirtualFile {
    @NotNull
    private final KotlinFileSystem fileSystem;
    @NotNull
    private final File file;
    @Nullable
    private final Function0<String> contentProvider;

    public KotlinVirtualFile(@NotNull KotlinFileSystem fileSystem, @NotNull File file, @Nullable Function0<String> contentProvider) {
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(file, "file");
        this.fileSystem = fileSystem;
        this.file = file;
        this.contentProvider = contentProvider;
    }

    public /* synthetic */ KotlinVirtualFile(KotlinFileSystem kotlinFileSystem, File file, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function0 = null;
        }
        this(kotlinFileSystem, file, function0);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName(this.file.getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue(string, "toSystemIndependentName(...)");
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        File file = this.file.getParentFile();
        if (file == null) {
            return null;
        }
        File parentFile = file;
        return new KotlinVirtualFile(this.fileSystem, parentFile, null, 4, null);
    }

    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        if (this.file.isFile() || !this.file.exists()) {
            return new VirtualFile[0];
        }
        throw new UnsupportedOperationException("getChildren " + this.file.getAbsolutePath());
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@Nullable Object p0, long p1, long p2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        if (this.contentProvider != null) {
            String string = this.contentProvider.invoke();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            return byArray;
        }
        byte[] byArray = FileUtil.loadFileBytes(this.file);
        Intrinsics.checkNotNullExpressionValue(byArray, "loadFileBytes(...)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @NotNull
    public Void refresh(boolean p0, boolean p1, @Nullable Runnable p2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }
}

