/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.checks;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaSimpleVariableAccess;
import org.jetbrains.kotlin.analysis.api.resolution.KaSimpleVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.signatures.KaCallableSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KaFunctionSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySetterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSyntheticJavaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.ArgumentMatcher;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u00a9\u0001\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000e\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&J\u000e\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020'J\u0018\u0010$\u001a\u00020\u000f2\u0010\u0010(\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010)J&\u0010$\u001a\u00020\u000f2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0002J\u001a\u00100\u001a\u00020\u000f2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00102\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00103\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0002J\u0014\u00104\u001a\u00020\u000f2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0002J\u0014\u00105\u001a\u00020\u000f2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0002J\u0014\u00106\u001a\u00020\u000f2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0002J\u0014\u00107\u001a\u00020\u000f2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0002J\u0014\u00108\u001a\u00020\u000f2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u0010\u0010\u001fR\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u0011\u0010\u001fR\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u0012\u0010\u001fR\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u0013\u0010\u001fR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "", "qualifiers", "", "", "names", "nameRegex", "Lkotlin/text/Regex;", "maxArgumentCount", "", "arguments", "", "Lorg/sonarsource/kotlin/api/checks/ArgumentMatcher;", "definingSupertypes", "matchConstructor", "", "isDynamic", "isExtensionFunction", "isSuspending", "isOperator", "returnType", "<init>", "(Ljava/util/Set;Ljava/util/Set;Lkotlin/text/Regex;ILjava/util/List;Ljava/util/Set;ZLjava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;)V", "getQualifiers", "()Ljava/util/Set;", "getNames", "getNameRegex", "()Lkotlin/text/Regex;", "getArguments", "()Ljava/util/List;", "getDefiningSupertypes", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getReturnType", "()Ljava/lang/String;", "qualifiersOrDefiningSupertypes", "matches", "node", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall;", "dispatchReceiver", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "callableSignature", "Lorg/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature;", "checkTypeOrSupertype", "getActualQualifier", "checkSubType", "checkName", "checkCallParameters", "checkIsExtensionFunction", "checkReturnType", "checkIsSuspending", "checkIsOperator", "sonar-kotlin-api"})
public final class FunMatcherImpl {
    @NotNull
    private final Set<String> qualifiers;
    @NotNull
    private final Set<String> names;
    @Nullable
    private final Regex nameRegex;
    private final int maxArgumentCount;
    @NotNull
    private final List<List<ArgumentMatcher>> arguments;
    @NotNull
    private final Set<String> definingSupertypes;
    private final boolean matchConstructor;
    @Nullable
    private final Boolean isDynamic;
    @Nullable
    private final Boolean isExtensionFunction;
    @Nullable
    private final Boolean isSuspending;
    @Nullable
    private final Boolean isOperator;
    @Nullable
    private final String returnType;
    @NotNull
    private final Set<String> qualifiersOrDefiningSupertypes;

    public FunMatcherImpl(@NotNull Set<String> qualifiers, @NotNull Set<String> names, @Nullable Regex nameRegex, int maxArgumentCount, @NotNull List<? extends List<ArgumentMatcher>> arguments2, @NotNull Set<String> definingSupertypes, boolean matchConstructor, @Nullable Boolean isDynamic, @Nullable Boolean isExtensionFunction, @Nullable Boolean isSuspending, @Nullable Boolean isOperator, @Nullable String returnType) {
        Intrinsics.checkNotNullParameter(qualifiers, "qualifiers");
        Intrinsics.checkNotNullParameter(names, "names");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(definingSupertypes, "definingSupertypes");
        this.qualifiers = qualifiers;
        this.names = names;
        this.nameRegex = nameRegex;
        this.maxArgumentCount = maxArgumentCount;
        this.arguments = arguments2;
        this.definingSupertypes = definingSupertypes;
        this.matchConstructor = matchConstructor;
        this.isDynamic = isDynamic;
        this.isExtensionFunction = isExtensionFunction;
        this.isSuspending = isSuspending;
        this.isOperator = isOperator;
        this.returnType = returnType;
        this.qualifiersOrDefiningSupertypes = this.definingSupertypes.isEmpty() ? this.qualifiers : (this.qualifiers.isEmpty() ? this.definingSupertypes : SetsKt.plus(this.qualifiers, (Iterable)this.definingSupertypes));
    }

    public /* synthetic */ FunMatcherImpl(Set set, Set set2, Regex regex, int n2, List list, Set set3, boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n3 & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n3 & 4) != 0) {
            regex = null;
        }
        if ((n3 & 8) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 0x20) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n3 & 0x40) != 0) {
            bl = false;
        }
        if ((n3 & 0x80) != 0) {
            bl2 = null;
        }
        if ((n3 & 0x100) != 0) {
            bl3 = null;
        }
        if ((n3 & 0x200) != 0) {
            bl4 = null;
        }
        if ((n3 & 0x400) != 0) {
            bl5 = null;
        }
        if ((n3 & 0x800) != 0) {
            string = null;
        }
        this(set, set2, regex, n2, list, set3, bl, bl2, bl3, bl4, bl5, string);
    }

    @NotNull
    public final Set<String> getQualifiers() {
        return this.qualifiers;
    }

    @NotNull
    public final Set<String> getNames() {
        return this.names;
    }

    @Nullable
    public final Regex getNameRegex() {
        return this.nameRegex;
    }

    @NotNull
    public final List<List<ArgumentMatcher>> getArguments() {
        return this.arguments;
    }

    @NotNull
    public final Set<String> getDefiningSupertypes() {
        return this.definingSupertypes;
    }

    @Nullable
    public final Boolean isDynamic() {
        return this.isDynamic;
    }

    @Nullable
    public final Boolean isExtensionFunction() {
        return this.isExtensionFunction;
    }

    @Nullable
    public final Boolean isSuspending() {
        return this.isSuspending;
    }

    @Nullable
    public final Boolean isOperator() {
        return this.isOperator;
    }

    @Nullable
    public final String getReturnType() {
        return this.returnType;
    }

    public final boolean matches(@NotNull KtCallExpression node) {
        Intrinsics.checkNotNullParameter(node, "node");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$matches_u24lambda_u240 = kaSession;
        boolean bl = false;
        KaCallInfo kaCallInfo = $this$matches_u24lambda_u240.resolveToCall(node);
        KaFunctionCall<?> call2 = kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null;
        return call2 != null && this.matches((KaCallableMemberCall)call2);
    }

    public final boolean matches(@NotNull KtNamedFunction node) {
        Intrinsics.checkNotNullParameter(node, "node");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$matches_u24lambda_u241 = kaSession;
        boolean bl = false;
        KaFunctionSymbol symbol = $this$matches_u24lambda_u241.getSymbol(node);
        return this.matches(null, symbol, (KaCallableSignature)$this$matches_u24lambda_u241.asSignature(symbol));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matches(@Nullable KaCallableMemberCall<?, ?> resolvedCall2) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$matches_u24lambda_u243 = kaSession;
        boolean bl = false;
        KaCallableMemberCall<?, ?> kaCallableMemberCall = resolvedCall2;
        if (kaCallableMemberCall == null) {
            return false;
        }
        if (!(kaCallableMemberCall instanceof KaFunctionCall)) {
            KaSymbol kaSymbol;
            KaSymbol symbolForNameCheck;
            if (!(kaCallableMemberCall instanceof KaSimpleVariableAccessCall)) throw new NoWhenBranchMatchedException();
            Object obj = KaCallKt.getSymbol(resolvedCall2);
            if (!(obj instanceof KaPropertySymbol)) return false;
            KaPropertySymbol kaPropertySymbol = (KaPropertySymbol)obj;
            if (kaPropertySymbol == null) {
                return false;
            }
            KaPropertySymbol propertySymbol = kaPropertySymbol;
            KaSimpleVariableAccess kaSimpleVariableAccess = ((KaSimpleVariableAccessCall)resolvedCall2).getSimpleAccess();
            if (kaSimpleVariableAccess instanceof KaSimpleVariableAccess.Read) {
                symbolForNameCheck = propertySymbol instanceof KaSyntheticJavaPropertySymbol ? (KaSymbol)((KaSyntheticJavaPropertySymbol)propertySymbol).getJavaGetterSymbol() : (KaSymbol)propertySymbol;
                if (!this.checkName((KaCallableSymbol)symbolForNameCheck)) return false;
                if (!this.arguments.isEmpty()) {
                    List argument;
                    Iterable iterable = this.arguments;
                    boolean $i$f$any = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        return false;
                    }
                    Iterator iterator2 = iterable.iterator();
                    do {
                        if (!iterator2.hasNext()) return false;
                        Object element$iv = iterator2.next();
                        argument = (List)element$iv;
                        boolean bl2 = false;
                    } while (!argument.isEmpty());
                    boolean bl3 = true;
                    if (!bl3) return false;
                }
                if (!this.checkReturnType((KaCallableSignature)$this$matches_u24lambda_u243.asSignature((KaVariableSymbol)propertySymbol))) return false;
                if (this.checkTypeOrSupertype(null, propertySymbol)) return true;
                if (!this.checkTypeOrSupertype(null, (KaCallableSymbol)symbolForNameCheck)) return false;
                return true;
            }
            if (!(kaSimpleVariableAccess instanceof KaSimpleVariableAccess.Write)) throw new NoWhenBranchMatchedException();
            if (propertySymbol instanceof KaSyntheticJavaPropertySymbol) {
                KaNamedFunctionSymbol kaNamedFunctionSymbol = ((KaSyntheticJavaPropertySymbol)propertySymbol).getJavaSetterSymbol();
                if (kaNamedFunctionSymbol == null) {
                    return false;
                }
                kaSymbol = kaNamedFunctionSymbol;
            } else {
                kaSymbol = propertySymbol;
            }
            symbolForNameCheck = kaSymbol;
            KaPropertySetterSymbol kaPropertySetterSymbol = propertySymbol.getSetter();
            KaLifetimeOwner kaLifetimeOwner = kaPropertySetterSymbol;
            if (kaPropertySetterSymbol == null) return false;
            if ((kaLifetimeOwner = $this$matches_u24lambda_u243.asSignature((KaFunctionSymbol)kaLifetimeOwner)) == null) {
                return false;
            }
            KaLifetimeOwner kaLifetimeOwner2 = kaLifetimeOwner;
            if (!this.checkName((KaCallableSymbol)symbolForNameCheck)) return false;
            if (!this.checkCallParameters((KaCallableSignature)kaLifetimeOwner2)) return false;
            if (!this.checkReturnType((KaCallableSignature)kaLifetimeOwner2)) return false;
            if (!this.checkTypeOrSupertype(null, (KaCallableSymbol)symbolForNameCheck)) return false;
            return true;
        }
        KaPartiallyAppliedSymbol symbol = ((KaFunctionCall)resolvedCall2).getPartiallyAppliedSymbol();
        boolean bl4 = this.matches(symbol.getDispatchReceiver(), (KaCallableSymbol)((KaFunctionSignature)symbol.getSignature()).getSymbol(), (KaCallableSignature<?>)symbol.getSignature());
        return bl4;
    }

    private final boolean matches(KaReceiverValue dispatchReceiver, KaCallableSymbol symbol, KaCallableSignature<?> callableSignature) {
        if (this.isDynamic != null) {
            throw new NotImplementedError(null, 1, null);
        }
        return callableSignature != null && this.checkIsExtensionFunction(callableSignature) && this.checkIsSuspending(callableSignature) && this.checkIsOperator(callableSignature) && this.checkReturnType(callableSignature) && this.checkName(symbol) && this.checkTypeOrSupertype(dispatchReceiver, symbol) && this.checkCallParameters(callableSignature);
    }

    private final boolean checkTypeOrSupertype(KaReceiverValue dispatchReceiver, KaCallableSymbol symbol) {
        String receiverFQN;
        if (this.qualifiersOrDefiningSupertypes.isEmpty()) {
            return true;
        }
        KaReceiverValue kaReceiverValue = dispatchReceiver;
        KaType kaType = kaReceiverValue != null ? kaReceiverValue.getType() : null;
        Object object = kaType instanceof KaClassType ? (KaClassType)kaType : null;
        String string = object != null && (object = ((KaClassType)object).getClassId()) != null ? ((ClassId)object).asFqNameString() : (receiverFQN = null);
        if (CollectionsKt.contains((Iterable)this.qualifiersOrDefiningSupertypes, receiverFQN)) {
            return true;
        }
        if (CollectionsKt.contains((Iterable)this.qualifiersOrDefiningSupertypes, this.getActualQualifier(symbol))) {
            return true;
        }
        Collection collection = this.definingSupertypes;
        return !(collection == null || collection.isEmpty()) && this.checkSubType(symbol);
    }

    private final String getActualQualifier(KaCallableSymbol symbol) {
        Object object;
        return symbol instanceof KaConstructorSymbol ? ApiExtensionsKt.asFqNameString(symbol.getReturnType()) : ((object = symbol.getCallableId()) != null && (object = ((CallableId)object).asSingleFqName()) != null && (object = ((FqName)object).parent()) != null ? ((FqName)object).asString() : null);
    }

    private final boolean checkSubType(KaCallableSymbol symbol) {
        boolean bl;
        block2: {
            boolean $i$f$withKaSession = false;
            KaSession kaSession = KotlinFileVisitorKt.getKaSession();
            Intrinsics.checkNotNull(kaSession);
            KaSession $this$checkSubType_u24lambda_u245 = kaSession;
            boolean bl2 = false;
            if (symbol instanceof KaConstructorSymbol) {
                return false;
            }
            Sequence<KaCallableSymbol> $this$any$iv = $this$checkSubType_u24lambda_u245.getAllOverriddenSymbols(symbol);
            boolean $i$f$any = false;
            Iterator<KaCallableSymbol> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                KaCallableSymbol element$iv;
                KaCallableSymbol it = element$iv = iterator2.next();
                boolean bl3 = false;
                Object object = it.getCallableId();
                String className = object != null && (object = ((CallableId)object).asSingleFqName()) != null && (object = ((FqName)object).parent()) != null ? ((FqName)object).asString() : null;
                if (!CollectionsKt.contains((Iterable)this.definingSupertypes, className)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean checkName(KaCallableSymbol symbol) {
        if (this.matchConstructor) {
            return symbol instanceof KaConstructorSymbol;
        }
        Object object = KaSymbolKt.getName(symbol);
        if (object == null || (object = ((Name)object).asString()) == null) {
            return false;
        }
        Object name = object;
        return this.nameRegex == null && this.names.isEmpty() || this.names.contains(name) || this.nameRegex != null && this.nameRegex.matches((CharSequence)name);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkCallParameters(KaCallableSignature<?> callableSignature) {
        boolean bl;
        Object obj = callableSignature.getSymbol();
        if (!(obj instanceof KaFunctionSymbol)) return false;
        KaFunctionSymbol kaFunctionSymbol = (KaFunctionSymbol)obj;
        if (kaFunctionSymbol == null) {
            return false;
        }
        KaFunctionSymbol symbol = kaFunctionSymbol;
        if (this.arguments.isEmpty()) return true;
        Iterable $this$any$iv = this.arguments;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            List it = (List)element$iv;
            boolean bl2 = false;
            if (symbol.getValueParameters().size() == it.size()) {
                void $this$foldRightIndexed$iv;
                List list = it;
                boolean initial$iv = true;
                boolean $i$f$foldRightIndexed = false;
                boolean accumulator$iv = initial$iv;
                if (!$this$foldRightIndexed$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$foldRightIndexed$iv.listIterator($this$foldRightIndexed$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        void argType;
                        void acc;
                        int index$iv = iterator$iv.previousIndex();
                        boolean bl3 = accumulator$iv;
                        ArgumentMatcher argumentMatcher = (ArgumentMatcher)iterator$iv.previous();
                        int i2 = index$iv;
                        boolean bl4 = false;
                        accumulator$iv = acc != false && argType.matches(symbol.getValueParameters().get(i2));
                    }
                }
                if (accumulator$iv) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean checkIsExtensionFunction(KaCallableSignature<?> callableSignature) {
        boolean bl;
        Boolean bl2 = this.isExtensionFunction;
        if (bl2 != null) {
            boolean it = bl2;
            boolean bl3 = false;
            bl = it == ((KaCallableSymbol)callableSignature.getSymbol()).isExtension();
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean checkReturnType(KaCallableSignature<?> callableSignature) {
        boolean bl;
        String string = this.returnType;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = Intrinsics.areEqual(it, ApiExtensionsKt.asFqNameString(callableSignature.getReturnType()));
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean checkIsSuspending(KaCallableSignature<?> callableSignature) {
        boolean bl;
        Boolean bl2 = this.isSuspending;
        if (bl2 != null) {
            KaNamedFunctionSymbol kaNamedFunctionSymbol;
            boolean it = bl2;
            boolean bl3 = false;
            Object obj = callableSignature.getSymbol();
            KaNamedFunctionSymbol kaNamedFunctionSymbol2 = kaNamedFunctionSymbol = obj instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)obj : null;
            bl = kaNamedFunctionSymbol != null ? it == kaNamedFunctionSymbol.isSuspend() : false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean checkIsOperator(KaCallableSignature<?> callableSignature) {
        boolean bl;
        Boolean bl2 = this.isOperator;
        if (bl2 != null) {
            KaNamedFunctionSymbol kaNamedFunctionSymbol;
            boolean it = bl2;
            boolean bl3 = false;
            Object obj = callableSignature.getSymbol();
            KaNamedFunctionSymbol kaNamedFunctionSymbol2 = kaNamedFunctionSymbol = obj instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)obj : null;
            bl = kaNamedFunctionSymbol != null ? it == kaNamedFunctionSymbol.isOperator() : false;
        } else {
            bl = true;
        }
        return bl;
    }

    public FunMatcherImpl() {
        this(null, null, null, 0, null, null, false, null, null, null, null, null, 4095, null);
    }
}

