/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonarsource.analyzer.commons.regex.RegexFeature;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.EscapedCharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;
import org.sonarsource.analyzer.commons.regex.ast.SimpleQuantifier;
import org.sonarsource.analyzer.commons.regex.helpers.SimplifiedRegexCharacterClass;

public class ReluctantQuantifierFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Replace this use of a reluctant quantifier with \"%s%s\".";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public ReluctantQuantifierFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitSequence(SequenceTree tree) {
        int repetitionPos;
        super.visitSequence(tree);
        List<RegexTree> items = tree.getItems();
        for (repetitionPos = items.size() - 2; repetitionPos > 0 && items.get(repetitionPos).is(RegexTree.Kind.NON_CAPTURING_GROUP) && ((NonCapturingGroupTree)items.get(repetitionPos)).getElement() == null; --repetitionPos) {
        }
        if (repetitionPos >= 0 && items.get(repetitionPos).is(RegexTree.Kind.REPETITION)) {
            RepetitionTree repetition = (RepetitionTree)items.get(repetitionPos);
            ReluctantQuantifierFinder.getReluctantlyQuantifiedElement(repetition).flatMap(element -> ReluctantQuantifierFinder.findNegatedCharacterClassFor((RegexTree)items.get(items.size() - 1), ReluctantQuantifierFinder.getBaseCharacter(element))).ifPresent(negatedClass -> {
                String newQuantifier = this.makePossessiveOrGreedy(repetition.getQuantifier(), ReluctantQuantifierFinder.supportsAnyOfFeatures(tree, RegexFeature.POSSESSIVE_QUANTIFIER));
                String message = String.format(MESSAGE, negatedClass, newQuantifier);
                this.regexElementIssueReporter.report(repetition, message, null, Collections.emptyList());
            });
        }
    }

    private static Optional<RegexTree> getReluctantlyQuantifiedElement(RepetitionTree repetition) {
        RegexTree element = repetition.getElement();
        while (element.is(RegexTree.Kind.NON_CAPTURING_GROUP)) {
            if ((element = ((NonCapturingGroupTree)element).getElement()) != null) continue;
            return Optional.empty();
        }
        return repetition.getQuantifier().getModifier() == Quantifier.Modifier.RELUCTANT && !repetition.getQuantifier().isFixed() && (element.is(RegexTree.Kind.DOT) || element.is(RegexTree.Kind.ESCAPED_CHARACTER_CLASS)) ? Optional.of(element) : Optional.empty();
    }

    protected String makePossessiveOrGreedy(Quantifier quantifier, boolean possessive) {
        String possessiveAddition;
        String string = possessiveAddition = possessive ? "+" : "";
        if (quantifier instanceof SimpleQuantifier) {
            return String.valueOf((Object)((SimpleQuantifier)quantifier).getKind()) + possessiveAddition;
        }
        String max = Optional.ofNullable(quantifier.getMaximumRepetitions()).map(Object::toString).orElse("");
        return String.format("{%d,%s}%s", quantifier.getMinimumRepetitions(), max, possessiveAddition);
    }

    private static Optional<String> findNegatedCharacterClassFor(RegexTree tree, EscapedCharacterClassTree base) {
        Object result2;
        if (tree instanceof CharacterClassElementTree && ReluctantQuantifierFinder.hasNoIntersection((CharacterClassElementTree)((Object)tree), base)) {
            return Optional.empty();
        }
        switch (tree.kind()) {
            case CHARACTER: {
                result2 = "[^" + tree.getText() + ReluctantQuantifierFinder.negateEscapedCharacter(base) + "]";
                break;
            }
            case ESCAPED_CHARACTER_CLASS: {
                EscapedCharacterClassTree escapedClass = (EscapedCharacterClassTree)tree;
                result2 = ReluctantQuantifierFinder.escapedCharacterFollowedByEscapedCharacter(escapedClass, ReluctantQuantifierFinder.negateEscapedCharacter(base));
                break;
            }
            case CHARACTER_CLASS: {
                CharacterClassTree characterClass = (CharacterClassTree)tree;
                String body = characterClass.getContents().getText();
                if (characterClass.isNegated()) {
                    result2 = "[" + body + ReluctantQuantifierFinder.escapedCharacterToString(base) + "]";
                    break;
                }
                result2 = "[^" + body + ReluctantQuantifierFinder.negateEscapedCharacter(base) + "]";
                break;
            }
            case NON_CAPTURING_GROUP: {
                RegexTree element = ((NonCapturingGroupTree)tree).getElement();
                return element == null ? Optional.empty() : ReluctantQuantifierFinder.findNegatedCharacterClassFor(element, base);
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.of(result2);
    }

    private static EscapedCharacterClassTree getBaseCharacter(RegexTree tree) {
        return tree.is(RegexTree.Kind.DOT) ? null : (EscapedCharacterClassTree)tree;
    }

    private static boolean hasNoIntersection(CharacterClassElementTree tree, CharacterClassElementTree base) {
        if (base == null) {
            return false;
        }
        SimplifiedRegexCharacterClass baseSimplifiedCharacterClass = new SimplifiedRegexCharacterClass(base);
        SimplifiedRegexCharacterClass treeSimplifiedCharacterClass = new SimplifiedRegexCharacterClass(tree);
        return !baseSimplifiedCharacterClass.intersects(treeSimplifiedCharacterClass, false);
    }

    private static String escapedCharacterFollowedByEscapedCharacter(EscapedCharacterClassTree escapedClass, String ignoredSymbol) {
        String negatedCharacter = ReluctantQuantifierFinder.backslash(escapedClass) + ReluctantQuantifierFinder.negateEscapedCharacterClassType(escapedClass.getType()) + ReluctantQuantifierFinder.getProperty(escapedClass);
        return ignoredSymbol.isEmpty() ? negatedCharacter : String.format("[%s%s]", negatedCharacter, ignoredSymbol);
    }

    private static String getProperty(EscapedCharacterClassTree escapedClass) {
        return escapedClass.isProperty() ? "{" + escapedClass.property() + "}" : "";
    }

    private static char negateEscapedCharacterClassType(char type2) {
        return Character.isLowerCase(type2) ? Character.toUpperCase(type2) : Character.toLowerCase(type2);
    }

    private static String negateEscapedCharacter(EscapedCharacterClassTree escapedClass) {
        return escapedClass == null ? "" : ReluctantQuantifierFinder.escapedCharacterFollowedByEscapedCharacter(escapedClass, "");
    }

    private static String escapedCharacterToString(EscapedCharacterClassTree escapedClass) {
        return escapedClass == null ? "" : ReluctantQuantifierFinder.backslash(escapedClass) + escapedClass.getType() + ReluctantQuantifierFinder.getProperty(escapedClass);
    }
}

