/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Collections;
import java.util.List;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexToken;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;

public abstract class GroupTree
extends RegexTree {
    private final RegexTree.Kind kind;
    protected final RegexTree element;
    private final RegexToken groupHeader;

    protected GroupTree(RegexSource source, RegexTree.Kind kind, RegexTree element, IndexRange range, FlagSet activeFlags) {
        super(source, range, activeFlags);
        this.kind = kind;
        this.element = element;
        this.groupHeader = element != null ? new RegexToken(source, new IndexRange(range.getBeginningOffset(), element.getRange().getBeginningOffset())) : null;
    }

    @Override
    public final RegexTree.Kind kind() {
        return this.kind;
    }

    public RegexToken getGroupHeader() {
        return this.groupHeader;
    }

    public RegexTree getElement() {
        return this.element;
    }

    public List<AutomatonState> successors() {
        return Collections.singletonList(this.element != null ? this.element : this.continuation());
    }

    @Override
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.EPSILON;
    }

    @Override
    public void setContinuation(AutomatonState continuation2) {
        this.setContinuation(continuation2, this.element);
    }

    protected void setContinuation(AutomatonState continuation2, RegexTree element) {
        super.setContinuation(continuation2);
        if (element != null) {
            element.setContinuation(continuation2);
        }
    }
}

