/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Arrays;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BranchState;
import org.sonarsource.analyzer.commons.regex.ast.EndOfConditionalSubpatternsState;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class ConditionalSubpatternTree
extends GroupTree {
    private final GroupTree condition;
    private final RegexTree yesPattern;
    private final SourceCharacter pipe;
    private final RegexTree noPattern;

    public ConditionalSubpatternTree(RegexSource source, SourceCharacter openingParen, SourceCharacter closingParen, GroupTree condition, RegexTree yesPattern, FlagSet activeFlags) {
        this(source, openingParen, closingParen, condition, yesPattern, null, null, activeFlags);
    }

    public ConditionalSubpatternTree(RegexSource source, SourceCharacter openingParen, SourceCharacter closingParen, GroupTree condition, RegexTree yesPattern, SourceCharacter pipe, RegexTree noPattern, FlagSet activeFlags) {
        this(source, openingParen.getRange().merge(closingParen.getRange()), condition, yesPattern, pipe, noPattern, activeFlags);
    }

    public ConditionalSubpatternTree(RegexSource source, IndexRange range, GroupTree condition, RegexTree yesPattern, SourceCharacter pipe, RegexTree noPattern, FlagSet activeFlags) {
        super(source, RegexTree.Kind.CONDITIONAL_SUBPATTERNS, null, range, activeFlags);
        this.condition = condition;
        this.yesPattern = yesPattern;
        this.pipe = pipe;
        this.noPattern = noPattern;
        EndOfConditionalSubpatternsState continuation2 = new EndOfConditionalSubpatternsState(this, activeFlags);
        yesPattern.setContinuation(continuation2);
        if (noPattern != null) {
            noPattern.setContinuation(continuation2);
        }
    }

    @Override
    protected void setContinuation(AutomatonState continuation2, RegexTree element) {
        super.setContinuation(continuation2, element);
        this.condition.setContinuation(new BranchState(this, Arrays.asList(this.yesPattern, this.noPattern == null ? continuation2 : this.noPattern), this.activeFlags()));
    }

    @Override
    public void accept(RegexVisitor visitor2) {
        visitor2.visitConditionalSubpattern(this);
    }

    @Override
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.EPSILON;
    }

    public GroupTree getCondition() {
        return this.condition;
    }

    public RegexTree getYesPattern() {
        return this.yesPattern;
    }

    public SourceCharacter getPipe() {
        return this.pipe;
    }

    public RegexTree getNoPattern() {
        return this.noPattern;
    }
}

