/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class BackReferenceTree
extends RegexTree {
    private final String groupName;
    private final SourceCharacter key;
    private CapturingGroupTree group;

    public BackReferenceTree(RegexSource source, SourceCharacter opener, SourceCharacter key, SourceCharacter start, SourceCharacter end, FlagSet activeFlags) {
        super(source, opener.getRange().merge(end.getRange()), activeFlags);
        this.key = key;
        char startCharacter = start.getCharacter();
        this.groupName = startCharacter != '<' && startCharacter != '\'' && startCharacter != '{' && startCharacter != '=' ? source.substringAt(start.getRange().merge(end.getRange())) : source.substringAt(new IndexRange(start.getRange().getBeginningOffset() + 1, end.getRange().getBeginningOffset()));
    }

    public void setGroup(CapturingGroupTree group) {
        this.group = group;
    }

    public CapturingGroupTree group() {
        return this.group;
    }

    @Override
    public void accept(RegexVisitor visitor2) {
        visitor2.visitBackReference(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.BACK_REFERENCE;
    }

    public boolean isNamedGroup() {
        return this.key != null;
    }

    public boolean isNumerical() {
        return this.key == null;
    }

    public String groupName() {
        return this.groupName;
    }

    public int groupNumber() {
        if (!this.isNumerical()) {
            return -1;
        }
        return Integer.parseInt(this.groupName);
    }

    @Override
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.BACK_REFERENCE;
    }
}

