/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.analyzer.commons.regex.RegexFeature;
import org.sonarsource.analyzer.commons.regex.RegexLexer;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.SyntaxError;
import org.sonarsource.analyzer.commons.regex.ast.AtomicGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.BackReferenceTree;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassIntersectionTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassUnionTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterRangeTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.ConditionalSubpatternTree;
import org.sonarsource.analyzer.commons.regex.ast.CurlyBraceQuantifier;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.DotTree;
import org.sonarsource.analyzer.commons.regex.ast.EscapedCharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.FinalState;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;
import org.sonarsource.analyzer.commons.regex.ast.MiscEscapeSequenceTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.PosixCharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.ReferenceConditionTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexToken;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;
import org.sonarsource.analyzer.commons.regex.ast.SimpleQuantifier;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;
import org.sonarsource.analyzer.commons.regex.ast.StartState;

public class RegexParser {
    private static final Logger LOG = LoggerFactory.getLogger(RegexParser.class);
    private static final String HEX_DIGIT = "hexadecimal digit";
    private static final String POSIX_CHARACTER_CLASS_PATTERN = "[:%s%s:]";
    private static final Set<String> POSIX_CHARACTER_CLASSES = new HashSet<String>(Arrays.asList("alnum", "alpha", "ascii", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "word", "xdigit", "<", ">"));
    private static final Map<String, String> POSIX_CHARACTER_CLASS_LOOKUP = RegexParser.posixCharacterClassMap(false);
    private static final Map<String, String> POSIX_CHARACTER_CLASS_NEGATION_LOOKUP = RegexParser.posixCharacterClassMap(true);
    protected final RegexSource source;
    protected final RegexLexer characters;
    protected FlagSet activeFlags;
    protected final List<BackReferenceTree> backReferences = new ArrayList<BackReferenceTree>();
    protected final Map<String, CapturingGroupTree> capturingGroups = new HashMap<String, CapturingGroupTree>();
    protected final List<SyntaxError> errors = new ArrayList<SyntaxError>();
    protected int groupNumber = 1;

    private static Map<String, String> posixCharacterClassMap(boolean negative) {
        return POSIX_CHARACTER_CLASSES.stream().collect(Collectors.toMap(posix -> String.format(POSIX_CHARACTER_CLASS_PATTERN, negative ? "^" : "", posix), posix -> posix));
    }

    public RegexParser(RegexSource source, FlagSet initialFlags) {
        this.source = source;
        this.characters = source.createLexer();
        this.characters.setFreeSpacingMode(initialFlags.contains(4));
        this.activeFlags = initialFlags;
    }

    public RegexParseResult parse() {
        RegexTree result2;
        FlagSet initialFlags = this.activeFlags;
        ArrayList<RegexTree> results = new ArrayList<RegexTree>();
        do {
            result2 = this.parseDisjunction();
            results.add(result2);
            if (!this.characters.isNotAtEnd()) continue;
            this.error("Unexpected '" + this.characters.getCurrent().getCharacter() + "'");
            this.characters.moveNext();
        } while (this.characters.isNotAtEnd());
        if (this.characters.isInQuotingMode()) {
            this.expected("'\\E'");
        }
        result2 = RegexParser.combineTrees(results, (range, elements) -> new SequenceTree(this.source, range, elements, initialFlags));
        StartState startState = new StartState(result2, initialFlags);
        FinalState finalState = new FinalState(this.activeFlags);
        result2.setContinuation(finalState);
        this.backReferences.forEach(reference -> reference.setGroup(this.capturingGroups.get(reference.groupName())));
        return new RegexParseResult(result2, startState, finalState, this.errors, this.characters.hasComments());
    }

    protected RegexTree parseDisjunction() {
        FlagSet disjunctionFlags = this.activeFlags;
        ArrayList<RegexTree> alternatives = new ArrayList<RegexTree>();
        ArrayList<SourceCharacter> orOperators = new ArrayList<SourceCharacter>();
        RegexTree first2 = this.parseSequence();
        alternatives.add(first2);
        while (this.characters.currentIs('|')) {
            orOperators.add(this.characters.getCurrent());
            this.characters.moveNext();
            RegexTree next = this.parseSequence();
            alternatives.add(next);
        }
        return RegexParser.combineTrees(alternatives, (range, elements) -> new DisjunctionTree(this.source, range, elements, orOperators, disjunctionFlags));
    }

    protected RegexTree parseSequence() {
        FlagSet sequenceFlags = this.activeFlags;
        ArrayList<RegexTree> elements = new ArrayList<RegexTree>();
        RegexTree element = this.parseRepetition();
        while (element != null) {
            elements.add(element);
            element = this.parseRepetition();
        }
        if (elements.isEmpty()) {
            int index2 = this.characters.getCurrentStartIndex();
            return new SequenceTree(this.source, new IndexRange(index2, index2), elements, sequenceFlags);
        }
        return RegexParser.combineTrees(elements, (range, items) -> new SequenceTree(this.source, range, items, sequenceFlags));
    }

    protected RegexTree parseRepetition() {
        FlagSet repetitionFlags = this.activeFlags;
        RegexTree element = this.parsePrimaryExpression();
        if (this.characters.isInQuotingMode()) {
            return element;
        }
        Quantifier quantifier = this.parseQuantifier();
        if (element == null) {
            if (quantifier != null) {
                this.errors.add(new SyntaxError(quantifier, "Unexpected quantifier '" + quantifier.getText() + "'"));
            }
            return null;
        }
        if (quantifier == null) {
            return element;
        }
        return new RepetitionTree(this.source, element.getRange().merge(quantifier.getRange()), element, quantifier, repetitionFlags);
    }

    protected Quantifier parseQuantifier() {
        SimpleQuantifier.Kind kind;
        switch (this.characters.getCurrentChar()) {
            case 42: {
                kind = SimpleQuantifier.Kind.STAR;
                break;
            }
            case 43: {
                kind = SimpleQuantifier.Kind.PLUS;
                break;
            }
            case 63: {
                kind = SimpleQuantifier.Kind.QUESTION_MARK;
                break;
            }
            case 123: {
                return this.parseCurlyBraceQuantifier();
            }
            default: {
                return null;
            }
        }
        SourceCharacter current = this.characters.getCurrent();
        this.characters.moveNext();
        Quantifier.Modifier modifier = this.parseQuantifierModifier();
        IndexRange range = current.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new SimpleQuantifier(this.source, range, modifier, kind);
    }

    CurlyBraceQuantifier parseCurlyBraceQuantifier() {
        if (this.supportsAnyOfFeatures(RegexFeature.UNESCAPED_CURLY_BRACKET) && !this.isCurlyBraceQuantifier()) {
            return null;
        }
        SourceCharacter openingBrace = this.characters.getCurrent();
        this.characters.moveNext();
        RegexToken lowerBound = this.parseInteger();
        if (lowerBound == null && !this.supportsAnyOfFeatures(RegexFeature.ONLY_UPPER_BOUND_QUANTIFIER)) {
            this.expected("integer");
            return null;
        }
        RegexToken comma = null;
        RegexToken upperBound = null;
        if (this.characters.currentIs(',')) {
            comma = new RegexToken(this.source, this.characters.getCurrent().getRange());
            this.characters.moveNext();
            upperBound = this.parseInteger();
        }
        if (this.characters.currentIs('}')) {
            this.characters.moveNext();
        } else if (comma == null) {
            this.expected("',' or '}'");
        } else if (upperBound == null) {
            this.expected("integer or '}'");
        } else {
            this.expected("'}'");
        }
        Quantifier.Modifier modifier = this.parseQuantifierModifier();
        IndexRange range = openingBrace.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new CurlyBraceQuantifier(this.source, range, modifier, lowerBound, comma, upperBound);
    }

    private boolean isCurlyBraceQuantifier() {
        int index2 = 1;
        if (!RegexParser.isAsciiDigit(this.characters.lookAhead(index2)) && !this.supportsAnyOfFeatures(RegexFeature.ONLY_UPPER_BOUND_QUANTIFIER)) {
            return false;
        }
        while (RegexParser.isAsciiDigit(this.characters.lookAhead(++index2))) {
        }
        if (this.characters.lookAhead(index2) == 125) {
            return true;
        }
        if (this.characters.lookAhead(index2) != 44) {
            return false;
        }
        while (RegexParser.isAsciiDigit(this.characters.lookAhead(++index2))) {
        }
        return this.characters.lookAhead(index2) == 125;
    }

    Quantifier.Modifier parseQuantifierModifier() {
        if (this.characters.currentIs('?')) {
            this.characters.moveNext();
            return Quantifier.Modifier.RELUCTANT;
        }
        if (this.characters.currentIs('+') && this.supportsAnyOfFeatures(RegexFeature.POSSESSIVE_QUANTIFIER)) {
            this.characters.moveNext();
            return Quantifier.Modifier.POSSESSIVE;
        }
        return Quantifier.Modifier.GREEDY;
    }

    protected RegexToken parseInteger() {
        int startIndex = this.characters.getCurrentStartIndex();
        if (!RegexParser.isAsciiDigit(this.characters.getCurrentChar())) {
            return null;
        }
        while (RegexParser.isAsciiDigit(this.characters.getCurrentChar())) {
            this.characters.moveNext();
        }
        IndexRange range = new IndexRange(startIndex, this.characters.getCurrentStartIndex());
        return new RegexToken(this.source, range);
    }

    protected RegexTree parsePrimaryExpression() {
        if (this.characters.isInQuotingMode() && this.characters.isNotAtEnd()) {
            return this.readCharacter();
        }
        switch (this.characters.getCurrentChar()) {
            case 40: {
                if (this.characters.currentIs("(?P=") && this.supportsAnyOfFeatures(RegexFeature.PYTHON_SYNTAX_GROUP_NAME)) {
                    return this.parsePythonBackReference();
                }
                return this.parseGroup();
            }
            case 92: {
                return this.parseEscapeSequence();
            }
            case 91: {
                return this.parseCharacterClass();
            }
            case 46: {
                DotTree tree = new DotTree(this.source, this.characters.getCurrentIndexRange(), this.activeFlags);
                this.characters.moveNext();
                return tree;
            }
            case 94: {
                BoundaryTree lineStart = new BoundaryTree(this.source, BoundaryTree.Type.LINE_START, this.characters.getCurrentIndexRange(), this.activeFlags);
                this.characters.moveNext();
                return lineStart;
            }
            case 36: {
                BoundaryTree lineEnd = new BoundaryTree(this.source, BoundaryTree.Type.LINE_END, this.characters.getCurrentIndexRange(), this.activeFlags);
                this.characters.moveNext();
                return lineEnd;
            }
        }
        if (this.isPlainTextCharacter(this.characters.getCurrentChar())) {
            return this.readCharacter();
        }
        return null;
    }

    private RegexTree parsePythonBackReference() {
        SourceCharacter openingParen = this.characters.getCurrent();
        this.characters.moveNext(2);
        return this.parseEscapedSequence('=', ')', "a group name", dh -> this.collect(new BackReferenceTree(this.source, openingParen, null, dh.opener, dh.closer, this.activeFlags)));
    }

    protected CharacterTree readCharacter() {
        SourceCharacter character = this.characters.getCurrent();
        this.characters.moveNext();
        return this.characterTree(character);
    }

    protected GroupTree parseGroup() {
        SourceCharacter openingParen = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.currentIs("?=")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.positiveLookAhead(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?<=")) {
            this.characters.moveNext(3);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.positiveLookBehind(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?!")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.negativeLookAhead(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?<!")) {
            this.characters.moveNext(3);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.negativeLookBehind(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?>") && this.supportsAnyOfFeatures(RegexFeature.ATOMIC_GROUP)) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> new AtomicGroupTree(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?<") && this.supportsAnyOfFeatures(RegexFeature.JAVA_SYNTAX_GROUP_NAME, RegexFeature.DOTNET_SYNTAX_GROUP_NAME)) {
            return this.finishGroup(openingParen, this.newNamedCapturingGroup(2, '>'));
        }
        if (this.characters.currentIs("?'") && this.supportsAnyOfFeatures(RegexFeature.DOTNET_SYNTAX_GROUP_NAME)) {
            return this.finishGroup(openingParen, this.newNamedCapturingGroup(2, '\''));
        }
        if (this.characters.currentIs("?P<") && this.supportsAnyOfFeatures(RegexFeature.PYTHON_SYNTAX_GROUP_NAME)) {
            return this.finishGroup(openingParen, this.newNamedCapturingGroup(3, '>'));
        }
        if (this.characters.currentIs("?")) {
            return this.parseNonCapturingGroup(openingParen);
        }
        return this.finishGroup(openingParen, this.newCapturingGroup(null));
    }

    protected GroupConstructor newNamedCapturingGroup(int namePrefixLength, char nameDelimiter) {
        this.characters.moveNext(namePrefixLength);
        String name = this.parseGroupName(nameDelimiter);
        if (this.characters.currentIs(nameDelimiter)) {
            this.characters.moveNext();
        } else {
            this.expected("'" + nameDelimiter + "'");
        }
        return this.newCapturingGroup(name);
    }

    protected GroupConstructor newCapturingGroup(String name) {
        int index2 = this.groupNumber++;
        return (range, inner) -> this.index(new CapturingGroupTree(this.source, range, name, index2, inner, this.activeFlags));
    }

    protected String parseGroupName(char nameDelimiter) {
        StringBuilder sb = new StringBuilder();
        while (this.characters.isNotAtEnd() && !this.characters.currentIs(nameDelimiter)) {
            sb.append(this.characters.getCurrent().getCharacter());
            this.characters.moveNext();
        }
        String name = sb.toString();
        if (name.isEmpty()) {
            this.expected("a name for the group");
        }
        return name;
    }

    protected GroupTree parseNonCapturingGroup(SourceCharacter openingParen) {
        FlagSet disabledFlags;
        this.characters.moveNext();
        if (this.characters.currentIs("R)") && this.source.supportsFeature(RegexFeature.RECURSION)) {
            return this.parseRecursion(openingParen);
        }
        if (this.characters.currentIs("(") && this.source.supportsFeature(RegexFeature.CONDITIONAL_SUBPATTERN)) {
            return this.parseConditionalSubpattern(openingParen);
        }
        FlagSet enabledFlags = this.parseFlags();
        if (this.characters.currentIs('-')) {
            this.characters.moveNext();
            disabledFlags = this.parseFlags();
        } else {
            disabledFlags = new FlagSet();
        }
        boolean previousFreeSpacingMode = this.characters.getFreeSpacingMode();
        if (disabledFlags.contains(4)) {
            this.characters.setFreeSpacingMode(false);
        } else if (enabledFlags.contains(4)) {
            this.characters.setFreeSpacingMode(true);
        }
        FlagSet previousFlags = this.activeFlags;
        if (!enabledFlags.isEmpty() || !disabledFlags.isEmpty()) {
            this.activeFlags = new FlagSet(this.activeFlags);
            this.activeFlags.addAll(enabledFlags);
            this.activeFlags.removeAll(disabledFlags);
        }
        if (this.characters.currentIs(')')) {
            SourceCharacter closingParen = this.characters.getCurrent();
            this.characters.moveNext();
            IndexRange range2 = openingParen.getRange().merge(closingParen.getRange());
            return new NonCapturingGroupTree(this.source, range2, enabledFlags, disabledFlags, null, this.activeFlags);
        }
        if (this.characters.currentIs(':')) {
            this.characters.moveNext();
        } else {
            this.expected("flag or ':' or ')'");
        }
        GroupTree group = this.finishGroup(previousFreeSpacingMode, openingParen, (range, inner) -> new NonCapturingGroupTree(this.source, range, enabledFlags, disabledFlags, inner, this.activeFlags));
        this.activeFlags = previousFlags;
        return group;
    }

    private GroupTree parseConditionalSubpattern(SourceCharacter openingParen) {
        GroupTree condition = this.parseCondition();
        RegexTree subpattern = this.parseDisjunction();
        SourceCharacter closingParen = this.characters.getCurrent();
        this.characters.moveNext();
        if (subpattern.is(RegexTree.Kind.DISJUNCTION)) {
            if (((DisjunctionTree)subpattern).getAlternatives().size() > 2) {
                this.error("More than two alternatives in the subpattern");
            }
            DisjunctionTree disjunction = (DisjunctionTree)subpattern;
            return new ConditionalSubpatternTree(this.source, openingParen, closingParen, condition, disjunction.getAlternatives().get(0), disjunction.getOrOperators().get(0), disjunction.getAlternatives().get(1), this.activeFlags);
        }
        return new ConditionalSubpatternTree(this.source, openingParen, closingParen, condition, subpattern, this.activeFlags);
    }

    private GroupTree parseCondition() {
        SourceCharacter openingParen = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.currentIs("?=")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.positiveLookAhead(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?<=")) {
            this.characters.moveNext(3);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.positiveLookBehind(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?!")) {
            this.characters.moveNext(2);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.negativeLookAhead(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("?<!")) {
            this.characters.moveNext(3);
            return this.finishGroup(openingParen, (range, inner) -> LookAroundTree.negativeLookBehind(this.source, range, inner, this.activeFlags));
        }
        if (this.characters.currentIs("+")) {
            CharacterTree plus = this.readCharacter();
            return this.finishGroup(openingParen, (range, inner) -> this.conditionGroupReference(this.source, range, plus, inner, this.activeFlags));
        }
        return this.finishGroup(openingParen, (range, inner) -> this.conditionGroupReference(this.source, range, null, inner, this.activeFlags));
    }

    public ReferenceConditionTree conditionGroupReference(RegexSource source, IndexRange range, CharacterTree plus, RegexTree inner, FlagSet activeFlags) {
        StringBuilder reference = new StringBuilder();
        if (plus != null) {
            reference.append('+');
        }
        if (inner.is(RegexTree.Kind.CHARACTER)) {
            reference.append(((CharacterTree)inner).characterAsString());
        } else if (inner.is(RegexTree.Kind.SEQUENCE)) {
            ((SequenceTree)inner).getItems().stream().filter(CharacterTree.class::isInstance).map(i2 -> ((CharacterTree)i2).characterAsString()).forEach(reference::append);
        } else {
            this.error("Conditional subpattern has invalid condition.");
        }
        return new ReferenceConditionTree(source, range, reference.toString(), activeFlags);
    }

    private GroupTree parseRecursion(SourceCharacter openingParen) {
        this.characters.moveNext();
        SourceCharacter closingParen = this.characters.getCurrent();
        this.characters.moveNext();
        IndexRange range = openingParen.getRange().merge(closingParen.getRange());
        return new NonCapturingGroupTree(this.source, range, new FlagSet(), new FlagSet(), null, this.activeFlags);
    }

    protected FlagSet parseFlags() {
        Integer flag;
        FlagSet flags = new FlagSet();
        while (this.characters.isNotAtEnd() && (flag = RegexParser.parseFlag(this.characters.getCurrent().getCharacter())) != null) {
            flags.add(flag, this.characters.getCurrent());
            this.characters.moveNext();
        }
        return flags;
    }

    protected static Integer parseFlag(char ch) {
        switch (ch) {
            case 'i': {
                return 2;
            }
            case 'd': {
                return 1;
            }
            case 'm': {
                return 8;
            }
            case 's': {
                return 32;
            }
            case 'u': {
                return 64;
            }
            case 'x': {
                return 4;
            }
            case 'U': {
                return 256;
            }
        }
        return null;
    }

    protected GroupTree finishGroup(SourceCharacter openingParen, GroupConstructor groupConstructor) {
        return this.finishGroup(this.characters.getFreeSpacingMode(), openingParen, groupConstructor);
    }

    protected GroupTree finishGroup(boolean previousFreeSpacingMode, SourceCharacter openingParen, GroupConstructor groupConstructor) {
        FlagSet previousFlagSet = this.activeFlags;
        RegexTree inner = this.parseDisjunction();
        this.activeFlags = previousFlagSet;
        this.characters.setFreeSpacingMode(previousFreeSpacingMode);
        if (this.characters.currentIs(')')) {
            this.characters.moveNext();
        } else {
            this.expected("')'");
        }
        IndexRange range = openingParen.getRange().extendTo(this.characters.getCurrentStartIndex());
        return groupConstructor.construct(range, inner);
    }

    protected RegexTree parseEscapeSequence() {
        SourceCharacter backslash = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.isAtEnd()) {
            this.expected("any character");
            return this.characterTree(backslash);
        }
        if (this.isEscapedCharacterClass()) {
            return this.parseEscapedProperty(backslash);
        }
        if (this.isEscapedBackReference()) {
            return this.parseNamedBackReference(backslash);
        }
        SourceCharacter character = this.characters.getCurrent();
        switch (character.getCharacter()) {
            case '0': {
                if (this.source.supportsFeature(RegexFeature.PHP_BINARY_ZERO)) {
                    return this.parsePhpOctalEscapeOrBinaryZero(backslash);
                }
                return this.parseOctalEscape(backslash);
            }
            case '1': 
            case '2': 
            case '3': {
                if (this.source.supportsFeature(RegexFeature.PYTHON_OCTAL_ESCAPE)) {
                    return this.parsePythonOctalEscapeOrNumericalBackReference(backslash);
                }
                return this.parseNumericalBackReference(backslash);
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumericalBackReference(backslash);
            }
            case 'A': 
            case 'B': 
            case 'G': 
            case 'Z': 
            case 'b': 
            case 'z': {
                return this.parseBoundary(backslash);
            }
            case 'D': 
            case 'H': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 's': 
            case 'v': 
            case 'w': {
                return this.parseEscapedCharacterClass(backslash);
            }
            case 'u': {
                return this.parseUnicodeEscape(backslash);
            }
            case 'x': {
                return this.parseHexEscape(backslash);
            }
            case 'a': 
            case 'e': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                this.characters.moveNext();
                char c2 = RegexParser.simpleEscapeToCharacter(character.getCharacter());
                IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
                return this.characterTree(new SourceCharacter(this.source, range, c2, true));
            }
            case 'c': {
                return this.parseControlSequence(backslash);
            }
            case 'N': {
                return this.parseNamedUnicodeCharacter(backslash);
            }
            case 'R': 
            case 'X': {
                this.characters.moveNext();
                return new MiscEscapeSequenceTree(this.source, backslash.getRange().extendTo(this.characters.getCurrentStartIndex()), this.activeFlags);
            }
            case 'E': {
                this.error("\\E used without \\Q");
            }
        }
        this.characters.moveNext();
        return new CharacterTree(this.source, backslash.getRange().merge(character.getRange()), character.getCharacter(), character.isEscapeSequence(), this.activeFlags);
    }

    private boolean isEscapedCharacterClass() {
        return (this.characters.currentIs('p') || this.characters.currentIs('P')) && this.supportsAnyOfFeatures(RegexFeature.ESCAPED_CHARACTER_CLASS);
    }

    private boolean isEscapedBackReference() {
        return this.characters.currentIs('k') && this.supportsAnyOfFeatures(RegexFeature.DOTNET_SYNTAX_GROUP_NAME, RegexFeature.JAVA_SYNTAX_GROUP_NAME, RegexFeature.PERL_SYNTAX_GROUP_NAME) || this.characters.currentIs('g') && this.supportsAnyOfFeatures(RegexFeature.PERL_SYNTAX_GROUP_NAME);
    }

    protected RegexTree parseNamedUnicodeCharacter(SourceCharacter backslash) {
        return this.parseEscapedSequence('{', '}', "a Unicode character name", content -> new MiscEscapeSequenceTree(this.source, backslash.getRange().merge(content.closer.getRange()), this.activeFlags));
    }

    protected RegexTree parseControlSequence(SourceCharacter backslash) {
        SourceCharacter c2 = this.characters.getCurrent();
        this.characters.moveNext();
        if (this.characters.isAtEnd()) {
            this.expected("any character");
            return this.characterTree(c2);
        }
        char controlCharacter = (char)(0x40 ^ this.characters.getCurrentChar());
        this.characters.moveNext();
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        return this.characterTree(new SourceCharacter(this.source, range, controlCharacter, true));
    }

    protected static char simpleEscapeToCharacter(char escapeCharacter) {
        switch (escapeCharacter) {
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
        }
        throw new IllegalArgumentException("Unsupported argument for simpleEscapeToCharacter: " + escapeCharacter);
    }

    protected RegexTree parseUnicodeEscape(SourceCharacter backslash) {
        this.characters.moveNext();
        char codeUnit = (char)this.parseFixedAmountOfHexDigits(4);
        return this.characterTree(new SourceCharacter(this.source, backslash.getRange().extendTo(this.characters.getCurrentStartIndex()), codeUnit, true));
    }

    protected RegexTree parseHexEscape(SourceCharacter backslash) {
        this.characters.moveNext();
        int codePoint = 0;
        if (this.characters.currentIs('{')) {
            this.characters.moveNext();
            if (!RegexParser.isHexDigit(this.characters.getCurrentChar())) {
                this.expected(HEX_DIGIT);
            }
            while (RegexParser.isHexDigit(this.characters.getCurrentChar())) {
                codePoint *= 16;
                codePoint += this.parseHexDigit();
            }
            if (this.characters.currentIs('}')) {
                this.characters.moveNext();
            } else {
                this.expected("hexadecimal digit or '}'");
            }
        } else {
            codePoint = this.parseFixedAmountOfHexDigits(2);
        }
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        CharacterTree tree = new CharacterTree(this.source, range, codePoint, true, this.activeFlags);
        if (!Character.isValidCodePoint(codePoint)) {
            this.errors.add(new SyntaxError(tree, "Invalid Unicode code point"));
        }
        return tree;
    }

    protected int parseFixedAmountOfHexDigits(int amount) {
        int i2;
        int result2 = 0;
        for (i2 = 0; i2 < amount && RegexParser.isHexDigit(this.characters.getCurrentChar()); ++i2) {
            result2 = (char)(result2 * 16);
            result2 = (char)(result2 + this.parseHexDigit());
        }
        if (i2 < amount) {
            this.expected(HEX_DIGIT);
        }
        return result2;
    }

    protected int parseHexDigit() {
        int value2 = Integer.parseInt("" + this.characters.getCurrent().getCharacter(), 16);
        this.characters.moveNext();
        return value2;
    }

    protected RegexTree parseEscapedCharacterClass(SourceCharacter backslash) {
        EscapedCharacterClassTree result2 = new EscapedCharacterClassTree(this.source, backslash, this.characters.getCurrent(), this.activeFlags);
        this.characters.moveNext();
        return result2;
    }

    protected RegexTree parseEscapedProperty(SourceCharacter backslash) {
        return this.parseEscapedSequence('{', '}', "a property name", dh -> new EscapedCharacterClassTree(this.source, backslash, dh.marker, dh.opener, dh.closer, this.activeFlags));
    }

    protected RegexTree parseNamedBackReference(SourceCharacter backslash) {
        if (this.characters.currentIs("k<") && this.supportsAnyOfFeatures(RegexFeature.DOTNET_SYNTAX_GROUP_NAME, RegexFeature.JAVA_SYNTAX_GROUP_NAME)) {
            return this.parseNamedBackReference(backslash, '<', '>');
        }
        if (this.characters.currentIs("k'") && this.supportsAnyOfFeatures(RegexFeature.DOTNET_SYNTAX_GROUP_NAME)) {
            return this.parseNamedBackReference(backslash, '\'', '\'');
        }
        if ((this.characters.currentIs("k{") || this.characters.currentIs("g{")) && this.supportsAnyOfFeatures(RegexFeature.PERL_SYNTAX_GROUP_NAME)) {
            return this.parseNamedBackReference(backslash, '{', '}');
        }
        this.characters.moveNext();
        this.expectedNamedBackReferenceOpener();
        return this.characterTree(backslash);
    }

    protected RegexTree parseNamedBackReference(SourceCharacter backslash, char opener, char closer) {
        return this.parseEscapedSequence(opener, closer, "a group name", dh -> this.collect(new BackReferenceTree(this.source, backslash, dh.marker, dh.opener, dh.closer, this.activeFlags)));
    }

    private void expectedNamedBackReferenceOpener() {
        StringJoiner joiner = new StringJoiner(" or ");
        joiner.setEmptyValue("valid name opener");
        if (this.source.supportsFeature(RegexFeature.DOTNET_SYNTAX_GROUP_NAME)) {
            joiner.add("'<'");
            joiner.add("'''");
        } else if (this.source.supportsFeature(RegexFeature.JAVA_SYNTAX_GROUP_NAME)) {
            joiner.add("'<'");
        }
        if (this.source.supportsFeature(RegexFeature.PERL_SYNTAX_GROUP_NAME)) {
            joiner.add("'{'");
        }
        this.expected(joiner.toString());
    }

    protected BackReferenceTree collect(BackReferenceTree backReference) {
        this.backReferences.add(backReference);
        return backReference;
    }

    protected CapturingGroupTree index(CapturingGroupTree capturingGroup) {
        this.capturingGroups.put(Integer.toString(capturingGroup.getGroupNumber()), capturingGroup);
        capturingGroup.getName().ifPresent(name -> this.capturingGroups.put((String)name, capturingGroup));
        return capturingGroup;
    }

    protected RegexTree parseEscapedSequence(char opener, char closer, String expected, Function<EscapedSequenceDataHolder, RegexTree> builder2) {
        SourceCharacter marker = this.characters.getCurrent();
        this.characters.moveNext();
        if (!this.characters.currentIs(opener)) {
            this.expected("'" + opener + "'");
            return this.characterTree(marker);
        }
        SourceCharacter openerChar = this.characters.getCurrent();
        boolean atLeastOneChar = false;
        do {
            this.characters.moveNext();
            if (this.characters.isAtEnd()) {
                this.expected((String)(atLeastOneChar ? "'" + closer + "'" : expected));
                return this.characterTree(openerChar);
            }
            if (!atLeastOneChar && this.characters.currentIs(closer)) {
                this.expected(expected);
                return this.characterTree(openerChar);
            }
            atLeastOneChar = true;
        } while (!this.characters.currentIs(closer));
        SourceCharacter closerChar = this.characters.getCurrent();
        this.characters.moveNext();
        return builder2.apply(new EscapedSequenceDataHolder(marker, openerChar, closerChar));
    }

    protected RegexTree parseNumericalBackReference(SourceCharacter backslash) {
        SourceCharacter firstDigit;
        SourceCharacter lastDigit = firstDigit = this.characters.getCurrent();
        int referenceNumber = firstDigit.getCharacter() - 48;
        do {
            boolean matchingGroupExistsAtThisPoint;
            this.characters.moveNext();
            if (this.characters.isAtEnd()) continue;
            SourceCharacter currentChar = this.characters.getCurrent();
            char asChar = currentChar.getCharacter();
            int newReferenceNumber = referenceNumber * 10 + (asChar - 48);
            boolean bl = matchingGroupExistsAtThisPoint = newReferenceNumber < this.groupNumber;
            if (!RegexParser.isAsciiDigit(asChar) || !matchingGroupExistsAtThisPoint) break;
            lastDigit = currentChar;
            referenceNumber = newReferenceNumber;
        } while (!this.characters.isAtEnd());
        return this.collect(new BackReferenceTree(this.source, backslash, null, firstDigit, lastDigit, this.activeFlags));
    }

    protected RegexTree parseOctalEscape(SourceCharacter backslash) {
        int newValue;
        int i2;
        this.characters.moveNext();
        char byteValue = '\u0000';
        for (i2 = 0; i2 < 3 && RegexParser.isOctalDigit(this.characters.getCurrentChar()) && (newValue = byteValue * 8 + this.characters.getCurrentChar() - 48) <= 255; ++i2) {
            byteValue = (char)newValue;
            this.characters.moveNext();
        }
        if (i2 == 0) {
            this.expected("octal digit");
        }
        IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
        return this.characterTree(new SourceCharacter(this.source, range, byteValue, true));
    }

    protected RegexTree parsePythonOctalEscapeOrNumericalBackReference(SourceCharacter backslash) {
        SourceCharacter firstDigit;
        SourceCharacter lastDigit = firstDigit = this.characters.getCurrent();
        StringBuilder escapedNumberSb = new StringBuilder();
        while (RegexParser.isAsciiDigit(this.characters.getCurrent().getCharacter())) {
            lastDigit = this.characters.getCurrent();
            escapedNumberSb.append(lastDigit.getCharacter());
            this.characters.moveNext();
            if (!this.characters.isAtEnd() && !RegexParser.isOctalEscape(escapedNumberSb)) continue;
        }
        if (RegexParser.isOctalEscape(escapedNumberSb)) {
            IndexRange range = backslash.getRange().extendTo(this.characters.getCurrentStartIndex());
            char escapedChar = (char)Integer.parseInt(escapedNumberSb, 0, escapedNumberSb.length(), 8);
            return this.characterTree(new SourceCharacter(this.source, range, escapedChar, true));
        }
        return this.collect(new BackReferenceTree(this.source, backslash, null, firstDigit, lastDigit, this.activeFlags));
    }

    protected RegexTree parsePhpOctalEscapeOrBinaryZero(SourceCharacter backslash) {
        int nextCharacter = this.characters.lookAhead(1);
        if (nextCharacter == 92 || nextCharacter == -1) {
            this.characters.moveNext();
            return this.characterTree(new SourceCharacter(this.source, backslash.getRange().extendTo(this.characters.getCurrentStartIndex()), '\u0000', true));
        }
        return this.parseOctalEscape(backslash);
    }

    private static boolean isOctalEscape(CharSequence escapedDigit) {
        try {
            return escapedDigit.length() == 3 && Integer.parseInt(escapedDigit, 0, escapedDigit.length(), 8) <= 255;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    protected RegexTree parseBoundary(SourceCharacter backslash) {
        if (this.characters.currentIs("b{")) {
            return this.parseEscapedSequence('{', '}', "an Unicode extended grapheme cluster", dh -> new BoundaryTree(this.source, BoundaryTree.Type.UNICODE_EXTENDED_GRAPHEME_CLUSTER, backslash.getRange().merge(dh.closer.getRange()), this.activeFlags));
        }
        SourceCharacter boundary = this.characters.getCurrent();
        this.characters.moveNext();
        return new BoundaryTree(this.source, BoundaryTree.Type.forKey(boundary.getCharacter()), backslash.getRange().merge(boundary.getRange()), this.activeFlags);
    }

    protected CharacterClassTree parseCharacterClass() {
        SourceCharacter openingBracket = this.characters.getCurrent();
        this.characters.moveNext();
        boolean negated = false;
        if (this.characters.currentIs('^')) {
            this.characters.moveNext();
            negated = true;
        }
        CharacterClassElementTree contents = this.parseCharacterClassIntersection();
        if (this.characters.currentIs(']')) {
            this.characters.moveNext();
        } else {
            this.expected("']'");
        }
        IndexRange range = openingBracket.getRange().extendTo(this.characters.getCurrentStartIndex());
        return new CharacterClassTree(this.source, range, openingBracket, negated, contents, this.activeFlags);
    }

    protected CharacterClassElementTree parseCharacterClassIntersection() {
        FlagSet characterClassFlags = this.activeFlags;
        ArrayList<CharacterClassElementTree> elements = new ArrayList<CharacterClassElementTree>();
        ArrayList<RegexToken> andOperators = new ArrayList<RegexToken>();
        elements.add(this.parseCharacterClassUnion(true));
        while (this.characters.currentIs("&&")) {
            SourceCharacter firstAnd = this.characters.getCurrent();
            this.characters.moveNext();
            SourceCharacter secondAnd = this.characters.getCurrent();
            this.characters.moveNext();
            andOperators.add(new RegexToken(this.source, firstAnd.getRange().merge(secondAnd.getRange())));
            elements.add(this.parseCharacterClassUnion(false));
        }
        return RegexParser.combineTrees(elements, (range, items) -> new CharacterClassIntersectionTree(this.source, range, items, andOperators, characterClassFlags));
    }

    protected CharacterClassElementTree parseCharacterClassUnion(boolean isAtBeginning) {
        FlagSet characterClassFlags = this.activeFlags;
        ArrayList<CharacterClassElementTree> elements = new ArrayList<CharacterClassElementTree>();
        CharacterClassElementTree element = this.parseCharacterClassElement(isAtBeginning);
        while (element != null) {
            elements.add(element);
            element = this.parseCharacterClassElement(false);
        }
        if (elements.isEmpty()) {
            IndexRange range2 = new IndexRange(this.characters.getCurrentStartIndex(), this.characters.getCurrentStartIndex());
            return new CharacterClassUnionTree(this.source, range2, elements, characterClassFlags);
        }
        return RegexParser.combineTrees(elements, (range, items) -> new CharacterClassUnionTree(this.source, range, items, characterClassFlags));
    }

    protected CharacterClassElementTree parseCharacterClassElement(boolean isAtBeginning) {
        PosixCharacterClassElementTree tree;
        if (this.characters.currentIs("[:") && this.source.supportsFeature(RegexFeature.POSIX_CHARACTER_CLASS) && (tree = this.parsePosixCharacterClass()) != null) {
            return tree;
        }
        if (this.characters.isInQuotingMode() && this.characters.isNotAtEnd()) {
            return this.readCharacter();
        }
        if (this.characters.isAtEnd() || this.characters.currentIs("&&")) {
            return null;
        }
        SourceCharacter startCharacter = this.characters.getCurrent();
        switch (startCharacter.getCharacter()) {
            case '\\': {
                RegexTree escape = this.parseEscapeSequence();
                if (escape.is(RegexTree.Kind.CHARACTER)) {
                    return this.parseCharacterRange((CharacterTree)escape);
                }
                if (escape instanceof CharacterClassElementTree) {
                    return (CharacterClassElementTree)((Object)escape);
                }
                this.errors.add(new SyntaxError(escape, "Invalid escape sequence inside character class"));
                return this.characterTree(new SourceCharacter(this.source, escape.getRange(), 'x'));
            }
            case ']': {
                if (isAtBeginning) {
                    this.characters.moveNext();
                    return this.parseCharacterRange(this.characterTree(startCharacter));
                }
                return null;
            }
            case '[': {
                if (!this.supportsAnyOfFeatures(RegexFeature.NESTED_CHARTER_CLASS)) break;
                return this.parseCharacterClass();
            }
        }
        this.characters.moveNext();
        return this.parseCharacterRange(this.characterTree(startCharacter));
    }

    protected PosixCharacterClassElementTree parsePosixCharacterClass() {
        SourceCharacter openingBracket = this.characters.getCurrent();
        boolean isNegation = this.characters.lookAhead(2) == 94;
        Map<String, String> posixLookup = isNegation ? POSIX_CHARACTER_CLASS_NEGATION_LOOKUP : POSIX_CHARACTER_CLASS_LOOKUP;
        Optional<Map.Entry> posixClass = posixLookup.entrySet().stream().filter(posix -> this.characters.currentIs((String)posix.getKey())).findFirst();
        if (posixClass.isPresent()) {
            this.characters.moveNext(((String)posixClass.get().getKey()).length());
            return new PosixCharacterClassElementTree(this.source, openingBracket, this.characters.getCurrent(), isNegation, (String)posixClass.get().getValue(), this.activeFlags);
        }
        return null;
    }

    protected CharacterClassElementTree parseCharacterRange(CharacterTree startCharacter) {
        if (this.characters.currentIs('-') && !this.characters.isInQuotingMode()) {
            int lookAhead = this.characters.lookAhead(1);
            if (lookAhead == -1 || lookAhead == 93) {
                return startCharacter;
            }
            if (lookAhead == 92) {
                this.characters.moveNext();
                SourceCharacter backslash = this.characters.getCurrent();
                RegexTree escape = this.parseEscapeSequence();
                if (escape.is(RegexTree.Kind.CHARACTER)) {
                    return this.characterRange(startCharacter, (CharacterTree)escape);
                }
                this.expected("simple character", escape);
                return this.characterRange(startCharacter, this.characterTree(backslash));
            }
            this.characters.moveNext();
            SourceCharacter endCharacter = this.characters.getCurrent();
            this.characters.moveNext();
            return this.characterRange(startCharacter, this.characterTree(endCharacter));
        }
        return startCharacter;
    }

    protected CharacterTree characterTree(SourceCharacter character) {
        char c1 = character.getCharacter();
        if (Character.isHighSurrogate(c1)) {
            char c2 = (char)this.characters.getCurrentChar();
            if (c2 == '\\') {
                this.characters.moveNext(2);
                int codePoint = this.parseFixedAmountOfHexDigits(4);
                IndexRange newRange = new IndexRange(character.getRange().getBeginningOffset(), character.getRange().getEndingOffset() + 1);
                return new CharacterTree(character.getSource(), newRange, Character.toCodePoint(c1, (char)codePoint), true, this.activeFlags);
            }
            if (Character.isLowSurrogate(c2)) {
                this.characters.moveNext();
                IndexRange newRange = new IndexRange(character.getRange().getBeginningOffset(), character.getRange().getEndingOffset() + 1);
                return new CharacterTree(character.getSource(), newRange, Character.toCodePoint(c1, c2), true, this.activeFlags);
            }
            LOG.warn("Couldn't parse '{}{}', two high surrogate characters in a row. Please check your encoding.", (Object)Character.valueOf(c1), (Object)Character.valueOf(c2));
        }
        return new CharacterTree(this.source, character.getRange(), character.getCharacter(), character.isEscapeSequence(), this.activeFlags);
    }

    protected CharacterRangeTree characterRange(CharacterTree startCharacter, CharacterTree endCharacter) {
        IndexRange range = startCharacter.getRange().merge(endCharacter.getRange());
        CharacterRangeTree characterRange = new CharacterRangeTree(this.source, range, startCharacter, endCharacter, this.activeFlags);
        if (startCharacter.codePointOrUnit() > endCharacter.codePointOrUnit()) {
            this.errors.add(new SyntaxError(characterRange, "Illegal character range"));
        }
        return characterRange;
    }

    protected void expected(String expectedToken, String actual) {
        this.error("Expected " + expectedToken + ", but found " + actual);
    }

    protected void expected(String expectedToken, RegexSyntaxElement actual) {
        this.expected(expectedToken, "'" + actual.getText() + "'");
    }

    protected void expected(String expectedToken) {
        String actual = this.characters.isAtEnd() ? "the end of the regex" : "'" + this.characters.getCurrent().getCharacter() + "'";
        this.expected(expectedToken, actual);
    }

    protected void error(String message) {
        IndexRange range = this.characters.getCurrentIndexRange();
        RegexToken offendingToken = new RegexToken(this.source, range);
        this.errors.add(new SyntaxError(offendingToken, message));
    }

    protected boolean supportsAnyOfFeatures(RegexFeature ... features) {
        return Arrays.stream(features).anyMatch(this.source::supportsFeature);
    }

    protected static <T extends RegexSyntaxElement> T combineTrees(List<T> elements, TreeConstructor<T> treeConstructor) {
        if (elements.size() == 1) {
            return (T)((RegexSyntaxElement)elements.get(0));
        }
        IndexRange range = ((RegexSyntaxElement)elements.get(0)).getRange().merge(((RegexSyntaxElement)elements.get(elements.size() - 1)).getRange());
        return (T)((RegexSyntaxElement)treeConstructor.construct(range, elements));
    }

    protected static boolean isAsciiDigit(int c2) {
        return 48 <= c2 && c2 <= 57;
    }

    protected static boolean isOctalDigit(int c2) {
        return 48 <= c2 && c2 <= 55;
    }

    protected static boolean isHexDigit(int c2) {
        return 48 <= c2 && c2 <= 57 || 97 <= c2 && c2 <= 102 || 65 <= c2 && c2 <= 70;
    }

    protected boolean isPlainTextCharacter(int c2) {
        if (c2 == 123) {
            return this.supportsAnyOfFeatures(RegexFeature.UNESCAPED_CURLY_BRACKET);
        }
        switch (c2) {
            case -1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 124: {
                return false;
            }
        }
        return true;
    }

    protected static interface TreeConstructor<T> {
        public T construct(IndexRange var1, List<T> var2);
    }

    protected static interface GroupConstructor {
        public GroupTree construct(IndexRange var1, RegexTree var2);
    }

    protected static final class EscapedSequenceDataHolder {
        private final SourceCharacter marker;
        private final SourceCharacter opener;
        private final SourceCharacter closer;

        private EscapedSequenceDataHolder(SourceCharacter marker, SourceCharacter opener, SourceCharacter closer) {
            this.marker = marker;
            this.opener = opener;
            this.closer = closer;
        }
    }
}

