/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.recognizers;

import org.sonarsource.analyzer.commons.recognizers.Detector;

public class CamelCaseDetector
extends Detector {
    public CamelCaseDetector(double probability) {
        super(probability);
    }

    @Override
    public int scan(String line) {
        char previousChar = ' ';
        for (int i2 = 0; i2 < line.length(); ++i2) {
            char indexChar = line.charAt(i2);
            if (CamelCaseDetector.isLowerCaseThenUpperCase(previousChar, indexChar)) {
                return 1;
            }
            previousChar = indexChar;
        }
        return 0;
    }

    private static boolean isLowerCaseThenUpperCase(char previousChar, char indexChar) {
        return Character.getType(previousChar) == 2 && Character.getType(indexChar) == 1;
    }
}

