/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.Version;
import org.sonarsource.analyzer.commons.JsonParser;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;

public class ExternalRuleLoader {
    private static final Long DEFAULT_CONSTANT_DEBT_MINUTES = 5L;
    private static final RuleType DEFAULT_ISSUE_TYPE = RuleType.CODE_SMELL;
    private static final Severity DEFAULT_SEVERITY = Severity.MAJOR;
    private static final String DESCRIPTION_ONLY_URL = "See description of %s rule <code>%s</code> at the <a href=\"%s\">%s website</a>.";
    private static final String DESCRIPTION_WITH_URL = "<p>%s</p> <p>See more at the <a href=\"%s\">%s website</a>.</p>";
    private static final String DESCRIPTION_FALLBACK = "This is external rule <code>%s:%s</code>. No details are available.";
    public static final Version API_VERSION_SUPPORTING_CLEAN_CODE_IMPACTS_AND_ATTRIBUTES = Version.create((int)10, (int)1);
    private final String linterKey;
    private final String linterName;
    private final String languageKey;
    private final boolean isCleanCodeImpactsAndAttributesSupported;
    private Map<String, ExternalRule> rulesMap = new HashMap<String, ExternalRule>();

    @Deprecated(since="2.6")
    public ExternalRuleLoader(String linterKey, String linterName, String pathToMetadata, String languageKey) {
        this(linterKey, linterName, pathToMetadata, languageKey, null);
    }

    public ExternalRuleLoader(String linterKey, String linterName, String pathToMetadata, String languageKey, SonarRuntime sonarRuntime) {
        this.linterKey = linterKey;
        this.linterName = linterName;
        this.languageKey = languageKey;
        this.isCleanCodeImpactsAndAttributesSupported = sonarRuntime != null && sonarRuntime.getApiVersion().isGreaterThanOrEqual(API_VERSION_SUPPORTING_CLEAN_CODE_IMPACTS_AND_ATTRIBUTES);
        this.loadMetadataFile(pathToMetadata);
    }

    public boolean isCleanCodeImpactsAndAttributesSupported() {
        return this.isCleanCodeImpactsAndAttributesSupported;
    }

    public void createExternalRuleRepository(RulesDefinition.Context context) {
        RulesDefinition.NewRepository externalRepo = context.createExternalRepository(this.linterKey, this.languageKey).setName(this.linterName);
        for (ExternalRule rule : this.rulesMap.values()) {
            RulesDefinition.NewRule newRule = externalRepo.createRule(rule.key).setName(rule.name);
            newRule.setHtmlDescription(rule.getDescription(this.linterKey, this.linterName));
            newRule.setDebtRemediationFunction(newRule.debtRemediationFunctions().constantPerIssue(rule.constantDebtMinutes + "min"));
            newRule.setType(rule.type);
            newRule.setSeverity(rule.severity.name());
            rule.applyCodeAttributeAndImpact(newRule);
            if (rule.tags == null) continue;
            newRule.setTags(rule.tags);
        }
        externalRepo.done();
    }

    public Set<String> ruleKeys() {
        return this.rulesMap.keySet();
    }

    public RuleType ruleType(String ruleKey) {
        ExternalRule externalRule = this.rulesMap.get(ruleKey);
        if (externalRule != null) {
            return externalRule.type;
        }
        return DEFAULT_ISSUE_TYPE;
    }

    public Severity ruleSeverity(String ruleKey) {
        ExternalRule externalRule = this.rulesMap.get(ruleKey);
        if (externalRule != null) {
            return externalRule.severity;
        }
        return DEFAULT_SEVERITY;
    }

    public Long ruleConstantDebtMinutes(String ruleKey) {
        ExternalRule externalRule = this.rulesMap.get(ruleKey);
        if (externalRule != null) {
            return externalRule.constantDebtMinutes;
        }
        return DEFAULT_CONSTANT_DEBT_MINUTES;
    }

    private void loadMetadataFile(String pathToMetadata) {
        InputStream inputStream = ExternalRuleLoader.class.getClassLoader().getResourceAsStream(pathToMetadata);
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            List<Map<String, Object>> rules = new JsonParser().parseArray(inputStreamReader);
            for (Map<String, Object> rule : rules) {
                ExternalRule externalRule = this.isCleanCodeImpactsAndAttributesSupported ? new ExternalRuleWithCodeAttribute(rule) : new ExternalRule(rule);
                this.rulesMap.put(externalRule.key, externalRule);
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException("Can't read resource: " + pathToMetadata, e2);
        }
    }

    private static class ExternalRule {
        final String key;
        final String name;
        final RuleType type;
        final Severity severity;
        final String url;
        final String description;
        final String[] tags;
        final Long constantDebtMinutes;

        public ExternalRule(Map<String, Object> rule) {
            this.key = (String)rule.get("key");
            this.name = (String)rule.get("name");
            this.url = (String)rule.get("url");
            this.description = (String)rule.get("description");
            this.constantDebtMinutes = (Long)rule.getOrDefault("constantDebtMinutes", DEFAULT_CONSTANT_DEBT_MINUTES);
            JSONArray tagsAsList = (JSONArray)rule.get("tags");
            this.tags = tagsAsList != null ? tagsAsList.toArray(new String[tagsAsList.size()]) : null;
            this.type = ExternalRule.getType(rule);
            this.severity = ExternalRule.getSeverity(rule);
        }

        public void applyCodeAttributeAndImpact(RulesDefinition.NewRule newRule) {
        }

        private static RuleType getType(Map<String, Object> rule) {
            String strType = (String)rule.get("type");
            if (strType != null) {
                return RuleType.valueOf((String)strType);
            }
            return DEFAULT_ISSUE_TYPE;
        }

        private static Severity getSeverity(Map<String, Object> rule) {
            String strSeverity = (String)rule.get("severity");
            if (strSeverity != null) {
                return Severity.valueOf((String)strSeverity);
            }
            return DEFAULT_SEVERITY;
        }

        String getDescription(String linterKey, String linterName) {
            if (this.description != null && this.url != null) {
                return String.format(ExternalRuleLoader.DESCRIPTION_WITH_URL, this.description, this.url, linterName);
            }
            if (this.description != null) {
                return this.description;
            }
            if (this.url != null) {
                return String.format(ExternalRuleLoader.DESCRIPTION_ONLY_URL, linterName, this.key, this.url, linterName);
            }
            return String.format(ExternalRuleLoader.DESCRIPTION_FALLBACK, linterKey, this.key);
        }
    }

    private static class ExternalRuleWithCodeAttribute
    extends ExternalRule {
        final CleanCodeAttribute codeAttribute;
        final Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> codeImpacts;

        public ExternalRuleWithCodeAttribute(Map<String, Object> rule) {
            super(rule);
            this.codeAttribute = ExternalRuleWithCodeAttribute.getCodeAttribute(rule);
            this.codeImpacts = ExternalRuleWithCodeAttribute.getCodeImpacts(rule);
        }

        @Override
        public void applyCodeAttributeAndImpact(RulesDefinition.NewRule newRule) {
            if (this.codeAttribute != null && this.codeImpacts != null) {
                newRule.setCleanCodeAttribute(this.codeAttribute);
                this.codeImpacts.forEach((arg_0, arg_1) -> ((RulesDefinition.NewRule)newRule).addDefaultImpact(arg_0, arg_1));
            }
        }

        private static CleanCodeAttribute getCodeAttribute(Map<String, Object> rule) {
            String attribute;
            JSONObject code = (JSONObject)rule.get("code");
            if (code != null && (attribute = (String)code.get("attribute")) != null) {
                return CleanCodeAttribute.valueOf((String)attribute);
            }
            return null;
        }

        private static Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> getCodeImpacts(Map<String, Object> rule) {
            JSONObject impacts;
            JSONObject code = (JSONObject)rule.get("code");
            if (code != null && (impacts = (JSONObject)code.get("impacts")) != null) {
                LinkedHashMap<SoftwareQuality, org.sonar.api.issue.impact.Severity> map2 = new LinkedHashMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>();
                impacts.forEach((k2, v2) -> map2.put(SoftwareQuality.valueOf((String)((String)k2)), org.sonar.api.issue.impact.Severity.valueOf((String)((String)v2))));
                return map2;
            }
            return null;
        }
    }
}

