/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.Context;
import org.sonar.api.server.rule.RuleDescriptionSection;
import org.sonar.api.server.rule.RuleDescriptionSectionBuilder;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.Version;

class EducationRuleLoader {
    private static final Logger LOG = LoggerFactory.getLogger(EducationRuleLoader.class);
    private static final String CODE_EXAMPLES_HEADER = "<h3>Code examples</h3>";
    private static final String WHY_SECTION_HEADER = "<h2>Why is this an issue\\?</h2>";
    private static final String HOW_TO_FIX_SECTION_HEADER = "<h2>How to fix it</h2>";
    private static final String RESOURCES_SECTION_HEADER = "<h2>Resources</h2>";
    private static final String HOW_TO_FIX_FRAMEWORK_SECTION_REGEX = "<h2>How to fix it in (?:(?:an|a|the)\\s)?(?<displayName>.*)</h2>";
    private static final Pattern HOW_TO_FIX_SECTION_PATTERN = Pattern.compile("<h2>How to fix it</h2>");
    private static final Pattern HOW_TO_FIX_FRAMEWORK_SECTION_PATTERN = Pattern.compile("<h2>How to fix it in (?:(?:an|a|the)\\s)?(?<displayName>.*)</h2>");
    private static final Pattern WHY_SECTION_HEADER_PATTERN = Pattern.compile("<h2>Why is this an issue\\?</h2>");
    private final SonarRuntime sonarRuntime;

    public EducationRuleLoader(SonarRuntime sonarRuntime) {
        this.sonarRuntime = sonarRuntime;
    }

    public void setEducationMetadataFromJson(RulesDefinition.NewRule rule, Map<String, Object> ruleMetadata) {
        if (!this.isEducationPrinciplesMetadataSupported()) {
            return;
        }
        Object propertyValue = ruleMetadata.get("educationPrinciples");
        if (propertyValue instanceof List) {
            String[] educationPrincipleKeys = ((List)propertyValue).toArray(new String[0]);
            rule.addEducationPrincipleKeys(educationPrincipleKeys);
        }
    }

    public String setEducationDescriptionFromHtml(RulesDefinition.NewRule rule, String description2) {
        if (!EducationRuleLoader.isEducationFormat(description2)) {
            return description2;
        }
        if (this.isEducationRuleDescriptionSupported()) {
            EducationRuleLoader.addEducationalRuleSections(rule, description2);
        }
        return EducationRuleLoader.fallbackHtmlDescription(description2);
    }

    static String fallbackHtmlDescription(String description2) {
        Matcher m2 = HOW_TO_FIX_FRAMEWORK_SECTION_PATTERN.matcher(description2);
        if (m2.find() && m2.find()) {
            int indexOfResourceSection = description2.indexOf(RESOURCES_SECTION_HEADER);
            String resourceSectionDescription = indexOfResourceSection > 0 ? description2.substring(indexOfResourceSection) : "";
            return description2.substring(0, m2.start()) + resourceSectionDescription;
        }
        return description2;
    }

    private static void addEducationalRuleSections(RulesDefinition.NewRule rule, String description2) {
        String[] split = description2.split(WHY_SECTION_HEADER);
        EducationRuleLoader.addSection(rule, "introduction", split[0]);
        split = split[1].split(RESOURCES_SECTION_HEADER);
        String rootCauseAndHowToFixItSections = split[0].replace(CODE_EXAMPLES_HEADER, "");
        Matcher frameworkSpecificHowToFixItSectionMatcher = HOW_TO_FIX_FRAMEWORK_SECTION_PATTERN.matcher(rootCauseAndHowToFixItSections);
        boolean hasFrameworkSpecificHowToFixItSection = frameworkSpecificHowToFixItSectionMatcher.find();
        boolean hasGenericHowToFixItSection = HOW_TO_FIX_SECTION_PATTERN.matcher(rootCauseAndHowToFixItSections).find();
        if (hasGenericHowToFixItSection && hasFrameworkSpecificHowToFixItSection) {
            throw new IllegalStateException(String.format("Invalid education rule format for '%s', rule description has both generic and framework-specific 'How to fix it' sections", rule.key()));
        }
        if (hasFrameworkSpecificHowToFixItSection) {
            String[] innerSplit = rootCauseAndHowToFixItSections.split(HOW_TO_FIX_FRAMEWORK_SECTION_REGEX);
            EducationRuleLoader.addSection(rule, "root_cause", innerSplit[0]);
            EducationRuleLoader.addContextSpecificHowToFixItSection(rule, innerSplit, frameworkSpecificHowToFixItSectionMatcher);
        } else if (hasGenericHowToFixItSection) {
            String[] innerSplit = rootCauseAndHowToFixItSections.split(HOW_TO_FIX_SECTION_HEADER);
            EducationRuleLoader.addSection(rule, "root_cause", innerSplit[0]);
            EducationRuleLoader.addSection(rule, "how_to_fix", innerSplit[1]);
        } else {
            EducationRuleLoader.addSection(rule, "root_cause", rootCauseAndHowToFixItSections);
        }
        if (split.length > 1) {
            EducationRuleLoader.addSection(rule, "resources", split[1]);
        }
    }

    private static void addContextSpecificHowToFixItSection(RulesDefinition.NewRule rule, String[] split, Matcher m2) {
        boolean match = true;
        int splitIndex = 1;
        while (match) {
            String displayName = m2.group("displayName").trim();
            String contextSpecificContent = split[splitIndex];
            String key = displayName.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "_");
            EducationRuleLoader.addSection(rule, "how_to_fix", contextSpecificContent, new Context(key, displayName));
            match = m2.find();
            ++splitIndex;
        }
    }

    private static void addSection(RulesDefinition.NewRule rule, String sectionKey, String content) {
        EducationRuleLoader.addSection(rule, sectionKey, content, null);
    }

    private static void addSection(RulesDefinition.NewRule rule, String sectionKey, String content, Context context) {
        String trimmedContent = content.trim();
        if (trimmedContent.isEmpty()) {
            return;
        }
        RuleDescriptionSectionBuilder sectionBuilder = RuleDescriptionSection.builder().sectionKey(sectionKey).htmlContent(trimmedContent).context(context);
        rule.addDescriptionSection(sectionBuilder.build());
    }

    private static boolean isEducationFormat(String description2) {
        return WHY_SECTION_HEADER_PATTERN.matcher(description2).find();
    }

    boolean isEducationRuleDescriptionSupported() {
        return this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)5));
    }

    boolean isEducationPrinciplesMetadataSupported() {
        return this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)8));
    }
}

