/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.exceptions;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.IndexNotReadyException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007"}, d2={"", "exception", "", "shouldIjPlatformExceptionBeRethrown", "(Ljava/lang/Throwable;)Z", "", "rethrowIntellijPlatformExceptionIfNeeded", "(Ljava/lang/Throwable;)V"})
public final class PlatformExceptionUtilsKt {
    public static final boolean shouldIjPlatformExceptionBeRethrown(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter(exception, "exception");
        Throwable throwable = exception;
        return throwable instanceof CancellationException ? true : (throwable instanceof ControlFlowException ? true : throwable instanceof IndexNotReadyException);
    }

    public static final void rethrowIntellijPlatformExceptionIfNeeded(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter(exception, "exception");
        if (PlatformExceptionUtilsKt.shouldIjPlatformExceptionBeRethrown(exception)) {
            throw exception;
        }
    }
}

