/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromBaseDirectory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\r8GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinPathsFromHomeDir;", "Lorg/jetbrains/kotlin/utils/KotlinPathsFromBaseDirectory;", "Ljava/io/File;", "homePath", "<init>", "(Ljava/io/File;)V", "Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;", "jar", "sourcesJar", "(Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;)Ljava/io/File;", "Ljava/io/File;", "getHomePath", "()Ljava/io/File;", "", "libsWithSources$delegate", "Lkotlin/Lazy;", "getLibsWithSources", "()Ljava/util/Set;", "libsWithSources"})
public final class KotlinPathsFromHomeDir
extends KotlinPathsFromBaseDirectory {
    @NotNull
    private final File homePath;
    @NotNull
    private final Lazy libsWithSources$delegate;

    public KotlinPathsFromHomeDir(@NotNull File homePath) {
        Intrinsics.checkNotNullParameter(homePath, "homePath");
        super(new File(homePath, "lib"));
        this.homePath = homePath;
        this.libsWithSources$delegate = LazyKt.lazy(KotlinPathsFromHomeDir::libsWithSources_delegate$lambda$0);
    }

    @Override
    @NotNull
    public File getHomePath() {
        return this.homePath;
    }

    @NotNull
    public final Set<KotlinPaths.Jar> getLibsWithSources() {
        Lazy lazy = this.libsWithSources$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @Nullable
    public File sourcesJar(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)jar, "jar");
        return this.getLibsWithSources().contains((Object)jar) ? super.sourcesJar(jar) : null;
    }

    private static final Set libsWithSources_delegate$lambda$0() {
        KotlinPaths.Jar[] jarArray = new KotlinPaths.Jar[]{KotlinPaths.Jar.StdLib, KotlinPaths.Jar.JsStdLib};
        return SetsKt.setOf(jarArray);
    }
}

