/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.util.Check;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001:\u0004\t\n\u000b\fB\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0004\r\u000e\u000f\u0010"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "Lorg/jetbrains/kotlin/util/Check;", "", "description", "<init>", "(Ljava/lang/String;)V", "Ljava/lang/String;", "getDescription", "()Ljava/lang/String;", "NoValueParameters", "SingleValueParameter", "AtLeast", "Equals", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$AtLeast;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$Equals;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$NoValueParameters;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$SingleValueParameter;"})
public abstract class ValueParameterCountCheck
implements Check {
    @NotNull
    private final String description;

    private ValueParameterCountCheck(String description2) {
        this.description = description2;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }

    public /* synthetic */ ValueParameterCountCheck(String description2, DefaultConstructorMarker $constructor_marker) {
        this(description2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$AtLeast;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "", "n", "<init>", "(I)V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "", "check", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "I", "getN", "()I"})
    public static final class AtLeast
    extends ValueParameterCountCheck {
        private final int n;

        public AtLeast(int n2) {
            super("must have at least " + n2 + " value parameter" + (n2 > 1 ? "s" : ""), null);
            this.n = n2;
        }

        public final int getN() {
            return this.n;
        }

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
            return functionDescriptor.getValueParameters().size() >= this.n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$Equals;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "", "n", "<init>", "(I)V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "", "check", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "I", "getN", "()I"})
    public static final class Equals
    extends ValueParameterCountCheck {
        private final int n;

        public Equals(int n2) {
            super("must have exactly " + n2 + " value parameters", null);
            this.n = n2;
        }

        public final int getN() {
            return this.n;
        }

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
            return functionDescriptor.getValueParameters().size() == this.n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$NoValueParameters;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "", "check", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z"})
    public static final class NoValueParameters
    extends ValueParameterCountCheck {
        @NotNull
        public static final NoValueParameters INSTANCE = new NoValueParameters();

        private NoValueParameters() {
            super("must have no value parameters", null);
        }

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
            return functionDescriptor.getValueParameters().isEmpty();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$SingleValueParameter;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "", "check", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z"})
    public static final class SingleValueParameter
    extends ValueParameterCountCheck {
        @NotNull
        public static final SingleValueParameter INSTANCE = new SingleValueParameter();

        private SingleValueParameter() {
            super("must have a single value parameter", null);
        }

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
            return functionDescriptor.getValueParameters().size() == 1;
        }
    }
}

