/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0087\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0087\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\rJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c7\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d7\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001d\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001e\u0010\rR\u0011\u0010 \u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/util/Time;", "", "", "nanos", "userNanos", "cpuNanos", "<init>", "(JJJ)V", "other", "plus", "(Lorg/jetbrains/kotlin/util/Time;)Lorg/jetbrains/kotlin/util/Time;", "minus", "component1", "()J", "component2", "component3", "copy", "(JJJ)Lorg/jetbrains/kotlin/util/Time;", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "J", "getNanos", "getUserNanos", "getCpuNanos", "getMillis", "millis", "Companion"})
public final class Time {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long nanos;
    private final long userNanos;
    private final long cpuNanos;
    @NotNull
    private static final Time ZERO = new Time(0L, 0L, 0L);

    public Time(long nanos, long userNanos, long cpuNanos) {
        this.nanos = nanos;
        this.userNanos = userNanos;
        this.cpuNanos = cpuNanos;
    }

    public final long getNanos() {
        return this.nanos;
    }

    public final long getUserNanos() {
        return this.userNanos;
    }

    public final long getCpuNanos() {
        return this.cpuNanos;
    }

    public final long getMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanos);
    }

    @NotNull
    public final Time plus(@NotNull Time other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Time(this.nanos + other.nanos, this.userNanos + other.userNanos, this.cpuNanos + other.cpuNanos);
    }

    @NotNull
    public final Time minus(@NotNull Time other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Time(this.nanos - other.nanos, this.userNanos - other.userNanos, this.cpuNanos - other.cpuNanos);
    }

    public final long component1() {
        return this.nanos;
    }

    public final long component2() {
        return this.userNanos;
    }

    public final long component3() {
        return this.cpuNanos;
    }

    @NotNull
    public final Time copy(long nanos, long userNanos, long cpuNanos) {
        return new Time(nanos, userNanos, cpuNanos);
    }

    public static /* synthetic */ Time copy$default(Time time, long l2, long l3, long l4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l2 = time.nanos;
        }
        if ((n2 & 2) != 0) {
            l3 = time.userNanos;
        }
        if ((n2 & 4) != 0) {
            l4 = time.cpuNanos;
        }
        return time.copy(l2, l3, l4);
    }

    @NotNull
    public String toString() {
        return "Time(nanos=" + this.nanos + ", userNanos=" + this.userNanos + ", cpuNanos=" + this.cpuNanos + ')';
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.nanos);
        result2 = result2 * 31 + Long.hashCode(this.userNanos);
        result2 = result2 * 31 + Long.hashCode(this.cpuNanos);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Time)) {
            return false;
        }
        Time time = (Time)other;
        if (this.nanos != time.nanos) {
            return false;
        }
        if (this.userNanos != time.userNanos) {
            return false;
        }
        return this.cpuNanos == time.cpuNanos;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/util/Time$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/util/Time;", "ZERO", "Lorg/jetbrains/kotlin/util/Time;", "getZERO", "()Lorg/jetbrains/kotlin/util/Time;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Time getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

