/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.Check;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B%\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0016\u0010\u0011\u0082\u0001\u0003\u001a\u001b\u001c"}, d2={"Lorg/jetbrains/kotlin/util/ReturnsCheck;", "Lorg/jetbrains/kotlin/util/Check;", "", "name", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "", "check", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function1;", "getType", "()Lkotlin/jvm/functions/Function1;", "description", "getDescription", "ReturnsBoolean", "ReturnsInt", "ReturnsUnit", "Lorg/jetbrains/kotlin/util/ReturnsCheck$ReturnsBoolean;", "Lorg/jetbrains/kotlin/util/ReturnsCheck$ReturnsInt;", "Lorg/jetbrains/kotlin/util/ReturnsCheck$ReturnsUnit;"})
public abstract class ReturnsCheck
implements Check {
    @NotNull
    private final String name;
    @NotNull
    private final Function1<KotlinBuiltIns, KotlinType> type;
    @NotNull
    private final String description;

    private ReturnsCheck(String name, Function1<? super KotlinBuiltIns, ? extends KotlinType> type2) {
        this.name = name;
        this.type = type2;
        this.description = "must return " + this.name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Function1<KotlinBuiltIns, KotlinType> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        return Intrinsics.areEqual(functionDescriptor.getReturnType(), this.type.invoke(DescriptorUtilsKt.getBuiltIns(functionDescriptor)));
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }

    public /* synthetic */ ReturnsCheck(String name, Function1 type2, DefaultConstructorMarker $constructor_marker) {
        this(name, type2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/util/ReturnsCheck$ReturnsBoolean;", "Lorg/jetbrains/kotlin/util/ReturnsCheck;", "<init>", "()V"})
    public static final class ReturnsBoolean
    extends ReturnsCheck {
        @NotNull
        public static final ReturnsBoolean INSTANCE = new ReturnsBoolean();

        private ReturnsBoolean() {
            super("Boolean", ReturnsBoolean::_init_$lambda$0, null);
        }

        private static final KotlinType _init_$lambda$0(KotlinBuiltIns kotlinBuiltIns) {
            Intrinsics.checkNotNullParameter(kotlinBuiltIns, "<this>");
            SimpleType simpleType2 = kotlinBuiltIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getBooleanType(...)");
            return simpleType2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/util/ReturnsCheck$ReturnsInt;", "Lorg/jetbrains/kotlin/util/ReturnsCheck;", "<init>", "()V"})
    public static final class ReturnsInt
    extends ReturnsCheck {
        @NotNull
        public static final ReturnsInt INSTANCE = new ReturnsInt();

        private ReturnsInt() {
            super("Int", ReturnsInt::_init_$lambda$0, null);
        }

        private static final KotlinType _init_$lambda$0(KotlinBuiltIns kotlinBuiltIns) {
            Intrinsics.checkNotNullParameter(kotlinBuiltIns, "<this>");
            SimpleType simpleType2 = kotlinBuiltIns.getIntType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getIntType(...)");
            return simpleType2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/util/ReturnsCheck$ReturnsUnit;", "Lorg/jetbrains/kotlin/util/ReturnsCheck;", "<init>", "()V"})
    public static final class ReturnsUnit
    extends ReturnsCheck {
        @NotNull
        public static final ReturnsUnit INSTANCE = new ReturnsUnit();

        private ReturnsUnit() {
            super("Unit", ReturnsUnit::_init_$lambda$0, null);
        }

        private static final KotlinType _init_$lambda$0(KotlinBuiltIns kotlinBuiltIns) {
            Intrinsics.checkNotNullParameter(kotlinBuiltIns, "<this>");
            SimpleType simpleType2 = kotlinBuiltIns.getUnitType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getUnitType(...)");
            return simpleType2;
        }
    }
}

