/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.AbstractModifierChecks;
import org.jetbrains.kotlin.util.Check;
import org.jetbrains.kotlin.util.Checks;
import org.jetbrains.kotlin.util.IsKPropertyCheck;
import org.jetbrains.kotlin.util.MemberKindCheck;
import org.jetbrains.kotlin.util.NoDefaultAndVarargsCheck;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.ReturnsCheck;
import org.jetbrains.kotlin.util.ValueParameterCountCheck;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0011X\u0091\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/util/OperatorChecks;", "Lorg/jetbrains/kotlin/util/AbstractModifierChecks;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiver", "", "incDecCheckForExpectClass", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)Z", "", "Lorg/jetbrains/kotlin/util/Checks;", "checks", "Ljava/util/List;", "getChecks$descriptors", "()Ljava/util/List;"})
public final class OperatorChecks
extends AbstractModifierChecks {
    @NotNull
    public static final OperatorChecks INSTANCE = new OperatorChecks();
    @NotNull
    private static final List<Checks> checks;

    private OperatorChecks() {
    }

    @Override
    @NotNull
    public List<Checks> getChecks$descriptors() {
        return checks;
    }

    private final boolean incDecCheckForExpectClass(FunctionDescriptor $this$incDecCheckForExpectClass, ReceiverParameterDescriptor receiver) {
        ReceiverValue receiverValue = receiver.getValue();
        Intrinsics.checkNotNullExpressionValue(receiverValue, "getValue(...)");
        ReceiverValue receiverValue2 = receiverValue;
        if (!(receiverValue2 instanceof ImplicitClassReceiver)) {
            return false;
        }
        ClassDescriptor classDescriptor = ((ImplicitClassReceiver)receiverValue2).getClassDescriptor();
        if (!classDescriptor.isExpect()) {
            return false;
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor);
        if (classId == null) {
            return false;
        }
        ClassId potentialActualAliasId = classId;
        ClassifierDescriptor classifierDescriptor = FindClassInModuleKt.findClassifierAcrossModuleDependencies(DescriptorUtilsKt.getModule(classDescriptor), potentialActualAliasId);
        TypeAliasDescriptor typeAliasDescriptor = classifierDescriptor instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)classifierDescriptor : null;
        if (typeAliasDescriptor == null) {
            return false;
        }
        TypeAliasDescriptor actualReceiverTypeAlias = typeAliasDescriptor;
        KotlinType kotlinType = $this$incDecCheckForExpectClass.getReturnType();
        if (kotlinType != null) {
            KotlinType returnType = kotlinType;
            boolean bl = false;
            return TypeUtilsKt.isSubtypeOf(returnType, actualReceiverTypeAlias.getExpandedType());
        }
        return false;
    }

    private static final String checks$lambda$2(FunctionDescriptor $this$Checks) {
        String string;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$Checks, "$this$Checks");
        List<ValueParameterDescriptor> list = $this$Checks.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.lastOrNull(list);
        if (valueParameterDescriptor != null) {
            ValueParameterDescriptor it = valueParameterDescriptor;
            boolean bl2 = false;
            bl = !DescriptorUtilsKt.declaresOrInheritsDefaultValue(it) && it.getVarargElementType() == null;
        } else {
            bl = false;
        }
        boolean lastIsOk = bl;
        AbstractModifierChecks this_$iv = INSTANCE;
        boolean $i$f$ensure = false;
        if (!lastIsOk) {
            boolean bl3 = false;
            string = "last parameter should not have a default value or be a vararg";
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean checks$lambda$6$isAny(DeclarationDescriptor $this$checks_u24lambda_u246_u24isAny) {
        return $this$checks_u24lambda_u246_u24isAny instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)$this$checks_u24lambda_u246_u24isAny);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String checks$lambda$6(FunctionDescriptor $this$Checks) {
        StringBuilder stringBuilder;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$Checks, "$this$Checks");
        AbstractModifierChecks abstractModifierChecks = INSTANCE;
        DeclarationDescriptor declarationDescriptor = $this$Checks.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        if (OperatorChecks.checks$lambda$6$isAny(declarationDescriptor)) return null;
        Collection<? extends FunctionDescriptor> collection = $this$Checks.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
        Iterable $this$any$iv = collection;
        boolean $i$f$any = false;
        if (((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv;
                boolean bl2 = false;
                DeclarationDescriptor declarationDescriptor2 = it.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor2, "getContainingDeclaration(...)");
                if (!OperatorChecks.checks$lambda$6$isAny(declarationDescriptor2)) continue;
                return null;
            }
            bl = false;
        }
        if (bl) return null;
        if (DescriptorUtilKt.isTypedEqualsInValueClass($this$Checks)) {
            return null;
        }
        boolean bl3 = false;
        boolean cond$iv = bl3;
        boolean $i$f$ensure = false;
        if (cond$iv) return null;
        boolean bl4 = false;
        StringBuilder $this$checks_u24lambda_u246_u24lambda_u245_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl5 = false;
        $this$checks_u24lambda_u246_u24lambda_u245_u24lambda_u244.append("must override ''equals()'' in Any");
        DeclarationDescriptor declarationDescriptor3 = $this$Checks.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor3, "getContainingDeclaration(...)");
        if (InlineClassesUtilsKt.isValueClass(declarationDescriptor3)) {
            DeclarationDescriptor declarationDescriptor4 = $this$Checks.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor4, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            SimpleType simpleType2 = ((ClassDescriptor)declarationDescriptor4).getDefaultType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
            String expectedParameterTypeRendered = DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2));
            $this$checks_u24lambda_u246_u24lambda_u245_u24lambda_u244.append(" or define ''equals(other: " + expectedParameterTypeRendered + "): Boolean''");
        }
        String string = stringBuilder.toString();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String checks$lambda$8(FunctionDescriptor $this$Checks) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$Checks, "$this$Checks");
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$Checks.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            receiverParameterDescriptor = $this$Checks.getExtensionReceiverParameter();
        }
        ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
        AbstractModifierChecks abstractModifierChecks = INSTANCE;
        if (receiver == null) return "receiver must be a supertype of the return type";
        KotlinType kotlinType = $this$Checks.getReturnType();
        if (kotlinType != null) {
            KotlinType kotlinType2 = receiver.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, kotlinType2);
        } else {
            bl = false;
        }
        if (bl) return null;
        if (!INSTANCE.incDecCheckForExpectClass($this$Checks, receiver)) return "receiver must be a supertype of the return type";
        return null;
    }

    static {
        Checks[] checksArray = new Checks[19];
        Object[] objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(1)};
        checksArray[0] = new Checks(OperatorNameConventions.GET, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(2)};
        checksArray[1] = new Checks(OperatorNameConventions.SET, (Check[])objectArray, OperatorChecks::checks$lambda$2);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(2), IsKPropertyCheck.INSTANCE};
        checksArray[2] = new Checks(OperatorNameConventions.GET_VALUE, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(3), IsKPropertyCheck.INSTANCE};
        checksArray[3] = new Checks(OperatorNameConventions.SET_VALUE, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.Equals(2), IsKPropertyCheck.INSTANCE};
        checksArray[4] = new Checks(OperatorNameConventions.PROVIDE_DELEGATE, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE};
        checksArray[5] = new Checks(OperatorNameConventions.INVOKE, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE};
        checksArray[6] = new Checks(OperatorNameConventions.CONTAINS, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        checksArray[7] = new Checks(OperatorNameConventions.ITERATOR, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        checksArray[8] = new Checks(OperatorNameConventions.NEXT, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE};
        checksArray[9] = new Checks(OperatorNameConventions.HAS_NEXT, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        checksArray[10] = new Checks(OperatorNameConventions.RANGE_TO, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        checksArray[11] = new Checks(OperatorNameConventions.RANGE_UNTIL, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.Member.INSTANCE};
        checksArray[12] = new Checks(OperatorNameConventions.EQUALS, (Check[])objectArray, OperatorChecks::checks$lambda$6);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsInt.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        checksArray[13] = new Checks(OperatorNameConventions.COMPARE_TO, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        checksArray[14] = new Checks(OperatorNameConventions.BINARY_OPERATION_NAMES, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        checksArray[15] = new Checks(OperatorNameConventions.SIMPLE_UNARY_OPERATION_NAMES, (Check[])objectArray, null, 4, null);
        objectArray = new Name[]{OperatorNameConventions.INC, OperatorNameConventions.DEC};
        Collection collection = CollectionsKt.listOf(objectArray);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE};
        checksArray[16] = new Checks(collection, (Check[])objectArray, OperatorChecks::checks$lambda$8);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsUnit.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        checksArray[17] = new Checks(OperatorNameConventions.ASSIGNMENT_OPERATIONS, (Check[])objectArray, null, 4, null);
        objectArray = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        checksArray[18] = new Checks(OperatorNameConventions.COMPONENT_REGEX, (Check[])objectArray, null, 4, null);
        checks = CollectionsKt.listOf(checksArray);
    }
}

