/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.IsConstantExpressionVisitor;

public class ConstUtils {
    public static boolean isCompileTimeConstant(@NotNull PsiVariable field) {
        if (field == null) {
            ConstUtils.$$$reportNull$$$0(0);
        }
        if (!field.hasModifierProperty("final")) {
            return false;
        }
        PsiType type2 = field.getType();
        return (TypeConversionUtil.isPrimitiveAndNotNull(type2) || type2.equalsToText("java.lang.String")) && field.hasInitializer() && ConstUtils.isConstantExpression(field.getInitializer());
    }

    private static boolean isConstantExpression(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor2 = new IsConstantExpressionVisitor();
        expression.accept(visitor2);
        return visitor2.isConstant();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/util/ConstUtils", "isCompileTimeConstant"));
    }
}

