/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.AbstractArrayMapOwner;
import org.jetbrains.kotlin.util.ArrayMap;
import org.jetbrains.kotlin.util.ArrayMapImpl;
import org.jetbrains.kotlin.util.EmptyArrayMap;
import org.jetbrains.kotlin.util.OneElementArrayMap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u0017\b\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00028\u0001H\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0014\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\r2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0016H\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019R0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00058\u0005@BX\u0085\u000e\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/util/AttributeArrayOwner;", "", "K", "T", "Lorg/jetbrains/kotlin/util/AbstractArrayMapOwner;", "Lorg/jetbrains/kotlin/util/ArrayMap;", "arrayMap", "<init>", "(Lorg/jetbrains/kotlin/util/ArrayMap;)V", "()V", "", "keyQualifiedName", "value", "", "registerComponent", "(Ljava/lang/String;Ljava/lang/Object;)V", "map", "", "expectedSize", "expectedImplementation", "buildDiagnosticMessage", "(Lorg/jetbrains/kotlin/util/ArrayMap;ILjava/lang/String;)Ljava/lang/String;", "Lkotlin/reflect/KClass;", "tClass", "removeComponent", "(Lkotlin/reflect/KClass;)V", "Lorg/jetbrains/kotlin/util/ArrayMap;", "getArrayMap", "()Lorg/jetbrains/kotlin/util/ArrayMap;"})
public abstract class AttributeArrayOwner<K, T>
extends AbstractArrayMapOwner<K, T> {
    @NotNull
    private ArrayMap<T> arrayMap;

    protected AttributeArrayOwner(@NotNull ArrayMap<T> arrayMap) {
        Intrinsics.checkNotNullParameter(arrayMap, "arrayMap");
        this.arrayMap = arrayMap;
    }

    @Override
    @NotNull
    protected final ArrayMap<T> getArrayMap() {
        return this.arrayMap;
    }

    public AttributeArrayOwner() {
        EmptyArrayMap emptyArrayMap = EmptyArrayMap.INSTANCE;
        Intrinsics.checkNotNull(emptyArrayMap, "null cannot be cast to non-null type org.jetbrains.kotlin.util.ArrayMap<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
        this(emptyArrayMap);
    }

    @Override
    protected final void registerComponent(@NotNull String keyQualifiedName, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(keyQualifiedName, "keyQualifiedName");
        Intrinsics.checkNotNullParameter(value2, "value");
        int id = this.getTypeRegistry().getId(keyQualifiedName);
        switch (this.arrayMap.getSize()) {
            case 0: {
                ArrayMap<T> map2 = this.arrayMap;
                if (!(map2 instanceof EmptyArrayMap)) {
                    throw new IllegalStateException(this.buildDiagnosticMessage(map2, 0, "EmptyArrayMap"));
                }
                this.arrayMap = new OneElementArrayMap<T>(value2, id);
                return;
            }
            case 1: {
                OneElementArrayMap oneElementArrayMap;
                ArrayMap<T> mapSnapshot = this.arrayMap;
                try {
                    Intrinsics.checkNotNull(mapSnapshot, "null cannot be cast to non-null type org.jetbrains.kotlin.util.OneElementArrayMap<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
                    oneElementArrayMap = (OneElementArrayMap)mapSnapshot;
                }
                catch (ClassCastException e2) {
                    throw new IllegalStateException(this.buildDiagnosticMessage(mapSnapshot, 1, "OneElementArrayMap"), e2);
                }
                OneElementArrayMap map3 = oneElementArrayMap;
                if (map3.getIndex() == id) {
                    this.arrayMap = new OneElementArrayMap<T>(value2, id);
                    return;
                }
                ArrayMapImpl newMap = new ArrayMapImpl();
                newMap.set(map3.getIndex(), map3.getValue());
                this.arrayMap = newMap;
            }
        }
        this.arrayMap.set(id, value2);
    }

    /*
     * WARNING - void declaration
     */
    private final String buildDiagnosticMessage(ArrayMap<T> map2, int expectedSize, String expectedImplementation) {
        void $this$mapIndexedTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$buildDiagnosticMessage_u24lambda_u243 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$buildDiagnosticMessage_u24lambda_u243.append("Race condition happened, the size of ArrayMap is " + expectedSize + " but it isn't an `" + expectedImplementation + '`').append('\n');
        $this$buildDiagnosticMessage_u24lambda_u243.append("Type: " + map2.getClass()).append('\n');
        StringBuilder $this$buildDiagnosticMessage_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        Map<String, Integer> services = this.getTypeRegistry().allValuesThreadUnsafeForRendering();
        $this$buildDiagnosticMessage_u24lambda_u243_u24lambda_u242.append("[").append('\n');
        Iterable $this$mapIndexed$iv = map2;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void value2;
            Object v0;
            void index2;
            Collection collection;
            block3: {
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t2 = item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = services.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl4 = false;
                    if (!(((Number)it.getValue()).intValue() == index2)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            Map.Entry service = v0;
            collection.add($this$buildDiagnosticMessage_u24lambda_u243_u24lambda_u242.append("  " + service + '[' + (int)index2 + "]: " + value2).append('\n'));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        $this$buildDiagnosticMessage_u24lambda_u243_u24lambda_u242.append("]").append('\n');
        String content = stringBuilder.toString();
        $this$buildDiagnosticMessage_u24lambda_u243.append("Content: " + content).append('\n');
        return stringBuilder2.toString();
    }

    protected final void removeComponent(@NotNull KClass<? extends K> tClass) {
        Intrinsics.checkNotNullParameter(tClass, "tClass");
        int id = this.getTypeRegistry().getId(tClass);
        if (this.arrayMap.get(id) == null) {
            return;
        }
        if (this.arrayMap.getSize() == 1) {
            EmptyArrayMap emptyArrayMap = EmptyArrayMap.INSTANCE;
            Intrinsics.checkNotNull(emptyArrayMap, "null cannot be cast to non-null type org.jetbrains.kotlin.util.ArrayMap<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
            this.arrayMap = emptyArrayMap;
        } else {
            ArrayMap<T> arrayMap = this.arrayMap;
            Intrinsics.checkNotNull(arrayMap, "null cannot be cast to non-null type org.jetbrains.kotlin.util.ArrayMapImpl<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
            ArrayMapImpl map2 = (ArrayMapImpl)arrayMap;
            map2.remove(id);
            if (map2.getSize() == 1) {
                ArrayMapImpl.Entry entry = CollectionsKt.first(map2.entries());
                int index2 = entry.component1();
                Object value2 = entry.component2();
                this.arrayMap = new OneElementArrayMap(value2, index2);
            }
        }
    }
}

