/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.AbstractIterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.ArrayMap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 #*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0002#$B!\b\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\u0006H\u0097\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0097\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u000eJ\u001b\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001aH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR$\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00068\u0016@RX\u0097\u000e\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\""}, d2={"Lorg/jetbrains/kotlin/util/ArrayMapImpl;", "", "T", "Lorg/jetbrains/kotlin/util/ArrayMap;", "", "data", "", "initialSize", "<init>", "([Ljava/lang/Object;I)V", "()V", "index", "", "ensureCapacity", "(I)V", "value", "set", "(ILjava/lang/Object;)V", "get", "(I)Ljava/lang/Object;", "copy", "()Lorg/jetbrains/kotlin/util/ArrayMap;", "", "iterator", "()Ljava/util/Iterator;", "remove", "", "Lorg/jetbrains/kotlin/util/ArrayMapImpl$Entry;", "entries", "()Ljava/util/List;", "[Ljava/lang/Object;", "size", "I", "getSize", "()I", "Companion", "Entry"})
public final class ArrayMapImpl<T>
extends ArrayMap<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Object[] data;
    private int size;

    private ArrayMapImpl(Object[] data2, int initialSize) {
        super(null);
        this.data = data2;
        this.size = initialSize;
    }

    public ArrayMapImpl() {
        this(new Object[20], 0);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final void ensureCapacity(int index2) {
        if (this.data.length > index2) {
            return;
        }
        int newSize = this.data.length;
        while ((newSize *= 2) <= index2) {
        }
        Object[] objectArray = Arrays.copyOf(this.data, newSize);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        this.data = objectArray;
    }

    @Override
    public void set(int index2, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.ensureCapacity(index2);
        if (this.data[index2] == null) {
            int n2 = this.getSize();
            this.size = n2 + 1;
        }
        this.data[index2] = value2;
    }

    @Override
    @Nullable
    public T get(int index2) {
        return (T)ArraysKt.getOrNull(this.data, index2);
    }

    @Override
    @NotNull
    public ArrayMap<T> copy() {
        Object[] objectArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        return new ArrayMapImpl<T>(objectArray, this.getSize());
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(this){
            private int index;
            final /* synthetic */ ArrayMapImpl<T> this$0;
            {
                this.this$0 = $receiver;
                this.index = -1;
            }

            protected void computeNext() {
                do {
                    int n2 = this.index;
                    this.index = n2 + 1;
                } while (this.index < ArrayMapImpl.access$getData$p(this.this$0).length && ArrayMapImpl.access$getData$p(this.this$0)[this.index] == null);
                if (this.index >= ArrayMapImpl.access$getData$p(this.this$0).length) {
                    this.done();
                } else {
                    Object object = ArrayMapImpl.access$getData$p(this.this$0)[this.index];
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of org.jetbrains.kotlin.util.ArrayMapImpl");
                    this.setNext(object);
                }
            }
        };
    }

    public final void remove(int index2) {
        if (this.data[index2] != null) {
            int n2 = this.getSize();
            this.size = n2 + -1;
        }
        this.data[index2] = null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entry<T>> entries() {
        void $this$mapIndexedNotNullTo$iv$iv;
        Object[] $this$mapIndexedNotNull$iv = this.data;
        boolean $i$f$mapIndexedNotNull = false;
        Object[] objectArray = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (void item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Entry<void> it$iv$iv;
            void value2;
            void element$iv$iv;
            int n2 = index$iv$iv$iv++;
            void var12_12 = item$iv$iv$iv;
            int index$iv$iv = n2;
            boolean bl = false;
            void var15_15 = element$iv$iv;
            int index2 = index$iv$iv;
            boolean bl2 = false;
            if ((value2 != null ? new Entry<void>(index2, value2) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Object[] access$getData$p(ArrayMapImpl $this) {
        return $this.data;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/util/ArrayMapImpl$Companion;", "", "<init>", "()V", "DEFAULT_SIZE", "", "INCREASE_K", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00010\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ*\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00028\u0001H\u00c7\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u0014H\u00d7\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u00038\u0017X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0005\u001a\u00028\u00018\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/util/ArrayMapImpl$Entry;", "T", "", "", "key", "value", "<init>", "(ILjava/lang/Object;)V", "component1", "()I", "component2", "()Ljava/lang/Object;", "copy", "(ILjava/lang/Object;)Lorg/jetbrains/kotlin/util/ArrayMapImpl$Entry;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getKey", "()Ljava/lang/Integer;", "Ljava/lang/Object;", "getValue"})
    public static final class Entry<T>
    implements Map.Entry<Integer, T>,
    KMappedMarker {
        private final int key;
        private final T value;

        public Entry(int key, T value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        @NotNull
        public Integer getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        public final int component1() {
            return this.key;
        }

        public final T component2() {
            return this.value;
        }

        @NotNull
        public final Entry<T> copy(int key, T value2) {
            return new Entry<T>(key, value2);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, int n2, Object object, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                n2 = entry.key;
            }
            if ((n3 & 2) != 0) {
                object = entry.value;
            }
            return entry.copy(n2, object);
        }

        @NotNull
        public String toString() {
            return "Entry(key=" + this.key + ", value=" + this.value + ')';
        }

        @Override
        public int hashCode() {
            int result2 = Integer.hashCode(this.key);
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (this.key != entry.key) {
                return false;
            }
            return Intrinsics.areEqual(this.value, entry.value);
        }

        @Override
        public T setValue(T newValue) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

