/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.TypeArgument;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001b\u0010\u0006\u001a\u00020\u0000*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a#\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a!\u0010\u0016\u001a\u00020\u000f*\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u00112\u0006\u0010\u0018\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/types/typesApproximation/TypeArgument;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "toTypeProjection", "(Lorg/jetbrains/kotlin/types/typesApproximation/TypeArgument;)Lorg/jetbrains/kotlin/types/TypeProjection;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "typeParameter", "toTypeArgument", "(Lorg/jetbrains/kotlin/types/TypeProjection;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;)Lorg/jetbrains/kotlin/types/typesApproximation/TypeArgument;", "typeProjection", "", "approximateContravariant", "approximateCapturedTypesIfNecessary", "(Lorg/jetbrains/kotlin/types/TypeProjection;Z)Lorg/jetbrains/kotlin/types/TypeProjection;", "substituteCapturedTypesWithProjections", "(Lorg/jetbrains/kotlin/types/TypeProjection;)Lorg/jetbrains/kotlin/types/TypeProjection;", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/types/typesApproximation/ApproximationBounds;", "approximateCapturedTypes", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/typesApproximation/ApproximationBounds;", "", "newTypeArguments", "replaceTypeArguments", "(Lorg/jetbrains/kotlin/types/KotlinType;Ljava/util/List;)Lorg/jetbrains/kotlin/types/KotlinType;", "typeArgument", "approximateProjection", "(Lorg/jetbrains/kotlin/types/typesApproximation/TypeArgument;)Lorg/jetbrains/kotlin/types/typesApproximation/ApproximationBounds;"})
public final class CapturedTypeApproximationKt {
    private static final TypeProjection toTypeProjection(TypeArgument $this$toTypeProjection) {
        boolean bl = $this$toTypeProjection.isConsistent();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            DescriptorRenderer descriptorRenderer2 = DescriptorRenderer.Companion.withOptions(CapturedTypeApproximationKt::toTypeProjection$lambda$1$lambda$0);
            String string = "Only consistent enhanced type projection can be converted to type projection, but [" + descriptorRenderer2.render($this$toTypeProjection.getTypeParameter()) + ": <" + descriptorRenderer2.renderType($this$toTypeProjection.getInProjection()) + ", " + descriptorRenderer2.renderType($this$toTypeProjection.getOutProjection()) + ">] was found";
            throw new AssertionError((Object)string);
        }
        return Intrinsics.areEqual($this$toTypeProjection.getInProjection(), $this$toTypeProjection.getOutProjection()) || $this$toTypeProjection.getTypeParameter().getVariance() == Variance.IN_VARIANCE ? (TypeProjection)new TypeProjectionImpl($this$toTypeProjection.getInProjection()) : (KotlinBuiltIns.isNothing($this$toTypeProjection.getInProjection()) && $this$toTypeProjection.getTypeParameter().getVariance() != Variance.IN_VARIANCE ? (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.OUT_VARIANCE), $this$toTypeProjection.getOutProjection()) : (KotlinBuiltIns.isNullableAny($this$toTypeProjection.getOutProjection()) ? (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.IN_VARIANCE), $this$toTypeProjection.getInProjection()) : (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant($this$toTypeProjection, Variance.OUT_VARIANCE), $this$toTypeProjection.getOutProjection())));
    }

    private static final TypeArgument toTypeArgument(TypeProjection $this$toTypeArgument, TypeParameterDescriptor typeParameter) {
        TypeArgument typeArgument;
        switch (WhenMappings.$EnumSwitchMapping$0[TypeSubstitutor.combine(typeParameter.getVariance(), $this$toTypeArgument).ordinal()]) {
            case 1: {
                KotlinType kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                KotlinType kotlinType2 = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType2);
                break;
            }
            case 2: {
                KotlinType kotlinType = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(typeParameter).getNullableAnyType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "getNullableAnyType(...)");
                typeArgument = new TypeArgument(typeParameter, kotlinType, simpleType2);
                break;
            }
            case 3: {
                SimpleType simpleType3 = DescriptorUtilsKt.getBuiltIns(typeParameter).getNothingType();
                Intrinsics.checkNotNullExpressionValue(simpleType3, "getNothingType(...)");
                KotlinType kotlinType = simpleType3;
                KotlinType kotlinType3 = $this$toTypeArgument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType3, "getType(...)");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeArgument;
    }

    @Nullable
    public static final TypeProjection approximateCapturedTypesIfNecessary(@Nullable TypeProjection typeProjection, boolean approximateContravariant) {
        if (typeProjection == null) {
            return null;
        }
        if (typeProjection.isStarProjection()) {
            return typeProjection;
        }
        KotlinType kotlinType = typeProjection.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KotlinType type2 = kotlinType;
        if (!TypeUtils.contains(type2, CapturedTypeApproximationKt::approximateCapturedTypesIfNecessary$lambda$2)) {
            return typeProjection;
        }
        Variance variance = typeProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)variance, "getProjectionKind(...)");
        Variance howThisTypeIsUsed = variance;
        if (howThisTypeIsUsed == Variance.OUT_VARIANCE) {
            ApproximationBounds<KotlinType> approximation = CapturedTypeApproximationKt.approximateCapturedTypes(type2);
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation.getUpper());
        }
        if (approximateContravariant) {
            KotlinType approximation = CapturedTypeApproximationKt.approximateCapturedTypes(type2).getLower();
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation);
        }
        return CapturedTypeApproximationKt.substituteCapturedTypesWithProjections(typeProjection);
    }

    private static final TypeProjection substituteCapturedTypesWithProjections(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){

            public TypeProjection get(TypeConstructor key) {
                Intrinsics.checkNotNullParameter(key, "key");
                CapturedTypeConstructor capturedTypeConstructor = key instanceof CapturedTypeConstructor ? (CapturedTypeConstructor)key : null;
                if (capturedTypeConstructor == null) {
                    return null;
                }
                CapturedTypeConstructor capturedTypeConstructor2 = capturedTypeConstructor;
                if (capturedTypeConstructor2.getProjection().isStarProjection()) {
                    return new TypeProjectionImpl(Variance.OUT_VARIANCE, capturedTypeConstructor2.getProjection().getType());
                }
                return capturedTypeConstructor2.getProjection();
            }
        });
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        return typeSubstitutor3.substituteWithoutApproximation(typeProjection);
    }

    @NotNull
    public static final ApproximationBounds<KotlinType> approximateCapturedTypes(@NotNull KotlinType type2) {
        KotlinType kotlinType;
        boolean lowerBoundIsTrivial;
        ArrayList<TypeArgument> upperBoundArguments;
        ArrayList<TypeArgument> lowerBoundArguments;
        block14: {
            boolean bl;
            Intrinsics.checkNotNullParameter(type2, "type");
            if (FlexibleTypesKt.isFlexible(type2)) {
                ApproximationBounds<KotlinType> boundsForFlexibleLower = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.lowerIfFlexible(type2));
                ApproximationBounds<KotlinType> boundsForFlexibleUpper = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.upperIfFlexible(type2));
                return new ApproximationBounds<KotlinType>(TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getLower()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getLower())), type2), TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getUpper()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getUpper())), type2));
            }
            TypeConstructor typeConstructor2 = type2.getConstructor();
            if (CapturedTypeConstructorKt.isCaptured(type2)) {
                ApproximationBounds<KotlinType> approximationBounds;
                Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor");
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor2).getProjection();
                KotlinType kotlinType2 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
                KotlinType bound = CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(kotlinType2, type2);
                switch (WhenMappings.$EnumSwitchMapping$0[typeProjection.getProjectionKind().ordinal()]) {
                    case 2: {
                        approximationBounds = new ApproximationBounds<KotlinType>(bound, TypeUtilsKt.getBuiltIns(type2).getNullableAnyType());
                        break;
                    }
                    case 3: {
                        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(type2).getNothingType();
                        Intrinsics.checkNotNullExpressionValue(simpleType2, "getNothingType(...)");
                        approximationBounds = new ApproximationBounds<KotlinType>(CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(simpleType2, type2), bound);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection));
                    }
                }
                return approximationBounds;
            }
            if (type2.getArguments().isEmpty() || type2.getArguments().size() != typeConstructor2.getParameters().size()) {
                return new ApproximationBounds<KotlinType>(type2, type2);
            }
            lowerBoundArguments = new ArrayList<TypeArgument>();
            upperBoundArguments = new ArrayList<TypeArgument>();
            Iterable iterable = type2.getArguments();
            List<TypeParameterDescriptor> list = typeConstructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
            for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list)) {
                boolean bl2;
                TypeProjection typeProjection = (TypeProjection)pair.component1();
                TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)pair.component2();
                Intrinsics.checkNotNull(typeParameter);
                TypeArgument typeArgument = CapturedTypeApproximationKt.toTypeArgument(typeProjection, typeParameter);
                if (typeProjection.isStarProjection()) {
                    lowerBoundArguments.add(typeArgument);
                    bl2 = upperBoundArguments.add(typeArgument);
                    continue;
                }
                ApproximationBounds<TypeArgument> approximationBounds = CapturedTypeApproximationKt.approximateProjection(typeArgument);
                TypeArgument lower = approximationBounds.component1();
                TypeArgument upper = approximationBounds.component2();
                lowerBoundArguments.add(lower);
                bl2 = upperBoundArguments.add(upper);
            }
            Iterable $this$any$iv = lowerBoundArguments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeArgument it = (TypeArgument)element$iv;
                    boolean bl3 = false;
                    if (!(!it.isConsistent())) continue;
                    bl = true;
                    break block14;
                }
                bl = lowerBoundIsTrivial = false;
            }
        }
        if (lowerBoundIsTrivial) {
            SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(type2).getNothingType();
            Intrinsics.checkNotNullExpressionValue(simpleType3, "getNothingType(...)");
            kotlinType = simpleType3;
        } else {
            kotlinType = CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)lowerBoundArguments);
        }
        return new ApproximationBounds<KotlinType>(kotlinType, CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)upperBoundArguments));
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType replaceTypeArguments(KotlinType $this$replaceTypeArguments, List<TypeArgument> newTypeArguments) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        boolean bl2 = bl = $this$replaceTypeArguments.getArguments().size() == newTypeArguments.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = false;
            String $i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22 = "Incorrect type arguments " + newTypeArguments;
            throw new AssertionError((Object)$i$a$-assert-CapturedTypeApproximationKt$replaceTypeArguments$22);
        }
        Iterable iterable = newTypeArguments;
        KotlinType kotlinType = $this$replaceTypeArguments;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeArgument typeArgument = (TypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(CapturedTypeApproximationKt.toTypeProjection((TypeArgument)it));
        }
        return TypeSubstitutionKt.replace$default(kotlinType, (List)destination$iv$iv, null, null, 6, null);
    }

    private static final ApproximationBounds<TypeArgument> approximateProjection(TypeArgument typeArgument) {
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getInProjection());
        KotlinType inLower = approximationBounds.component1();
        KotlinType inUpper = approximationBounds.component2();
        ApproximationBounds<KotlinType> approximationBounds2 = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getOutProjection());
        KotlinType outLower = approximationBounds2.component1();
        KotlinType outUpper = approximationBounds2.component2();
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), inUpper, outLower), new TypeArgument(typeArgument.getTypeParameter(), inLower, outUpper));
    }

    private static final Unit toTypeProjection$lambda$1$lambda$0(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter($this$withOptions, "$this$withOptions");
        $this$withOptions.setClassifierNamePolicy(ClassifierNamePolicy.FULLY_QUALIFIED.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Variance toTypeProjection$removeProjectionIfRedundant(TypeArgument $this_toTypeProjection, Variance variance) {
        return variance == $this_toTypeProjection.getTypeParameter().getVariance() ? Variance.INVARIANT : variance;
    }

    private static final Boolean approximateCapturedTypesIfNecessary$lambda$2(UnwrappedType it) {
        Intrinsics.checkNotNull(it);
        return CapturedTypeConstructorKt.isCaptured(it);
    }

    private static final KotlinType approximateCapturedTypes$makeNullableIfNeeded(KotlinType $this$approximateCapturedTypes_u24makeNullableIfNeeded, KotlinType $type) {
        KotlinType kotlinType = TypeUtils.makeNullableIfNeeded($this$approximateCapturedTypes_u24makeNullableIfNeeded, $type.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNullableIfNeeded(...)");
        return kotlinType;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

