/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.error;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.error.ErrorClassDescriptor;
import org.jetbrains.kotlin.types.error.ErrorEntity;
import org.jetbrains.kotlin.types.error.ErrorModuleDescriptor;
import org.jetbrains.kotlin.types.error.ErrorPropertyDescriptor;
import org.jetbrains.kotlin.types.error.ErrorScope;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeConstructor;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ThrowingScope;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0012J+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00132\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00172\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0019J9\u0010\u001d\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJA\u0010\u001d\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0018\u001a\u00020\u00172\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001fJ+\u0010!\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u00132\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010#\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010)\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010'\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010+\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0004\b+\u0010*J\u0017\u0010,\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010#\u00a2\u0006\u0004\b,\u0010&J\u0015\u0010-\u001a\u00020\u00062\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b-\u0010&J\u0017\u0010.\u001a\u00020\f2\u0006\u0010$\u001a\u00020#H\u0007\u00a2\u0006\u0004\b.\u0010/R\u001a\u00101\u001a\u0002008\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u001a\u00106\u001a\u0002058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\u00020#8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020#8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b>\u0010;\u001a\u0004\b?\u0010=R\u0014\u0010A\u001a\u00020@8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR \u0010D\u001a\b\u0012\u0004\u0012\u00020@0C8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G"}, d2={"Lorg/jetbrains/kotlin/types/error/ErrorUtils;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "function", "", "containsErrorTypeInParameters", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;", "kind", "", "", "formatParams", "Lorg/jetbrains/kotlin/types/error/ErrorScope;", "createErrorScope", "(Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorScope;", "throwExceptions", "(Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;Z[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorScope;", "Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;", "Lorg/jetbrains/kotlin/types/error/ErrorType;", "createErrorType", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorType;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "typeConstructor", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;Lorg/jetbrains/kotlin/types/TypeConstructor;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorType;", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "arguments", "createErrorTypeWithArguments", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;Ljava/util/List;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorType;", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;Ljava/util/List;Lorg/jetbrains/kotlin/types/TypeConstructor;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorType;", "Lorg/jetbrains/kotlin/types/error/ErrorTypeConstructor;", "createErrorTypeConstructor", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;[Ljava/lang/String;)Lorg/jetbrains/kotlin/types/error/ErrorTypeConstructor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "containsErrorType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "candidate", "isError", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isErrorClass", "isUninferredTypeVariable", "containsUninferredTypeVariable", "unresolvedTypeAsItIs", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "errorModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getErrorModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/types/error/ErrorClassDescriptor;", "errorClass", "Lorg/jetbrains/kotlin/types/error/ErrorClassDescriptor;", "getErrorClass", "()Lorg/jetbrains/kotlin/types/error/ErrorClassDescriptor;", "errorTypeForLoopInSupertypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "getErrorTypeForLoopInSupertypes", "()Lorg/jetbrains/kotlin/types/KotlinType;", "errorPropertyType", "getErrorPropertyType", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "errorProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "", "errorPropertyGroup", "Ljava/util/Set;", "getErrorPropertyGroup", "()Ljava/util/Set;"})
public final class ErrorUtils {
    @NotNull
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    @NotNull
    private static final ModuleDescriptor errorModule = ErrorModuleDescriptor.INSTANCE;
    @NotNull
    private static final ErrorClassDescriptor errorClass;
    @NotNull
    private static final KotlinType errorTypeForLoopInSupertypes;
    @NotNull
    private static final KotlinType errorPropertyType;
    @NotNull
    private static final PropertyDescriptor errorProperty;
    @NotNull
    private static final Set<PropertyDescriptor> errorPropertyGroup;

    private ErrorUtils() {
    }

    @NotNull
    public final ModuleDescriptor getErrorModule() {
        return errorModule;
    }

    @NotNull
    public final ErrorClassDescriptor getErrorClass() {
        return errorClass;
    }

    @NotNull
    public final KotlinType getErrorTypeForLoopInSupertypes() {
        return errorTypeForLoopInSupertypes;
    }

    @NotNull
    public final KotlinType getErrorPropertyType() {
        return errorPropertyType;
    }

    @NotNull
    public final Set<PropertyDescriptor> getErrorPropertyGroup() {
        return errorPropertyGroup;
    }

    public final boolean containsErrorTypeInParameters(@NotNull FunctionDescriptor function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        ReceiverParameterDescriptor receiverParameter = function2.getExtensionReceiverParameter();
        if (receiverParameter != null && this.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function2.getValueParameters()) {
            if (!this.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function2.getTypeParameters()) {
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!this.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final ErrorScope createErrorScope(@NotNull ErrorScopeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return ErrorUtils.createErrorScope(kind, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public static final ErrorScope createErrorScope(@NotNull ErrorScopeKind kind, boolean throwExceptions, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return throwExceptions ? (ErrorScope)new ThrowingScope(kind, Arrays.copyOf(formatParams, formatParams.length)) : new ErrorScope(kind, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public static final ErrorType createErrorType(@NotNull ErrorTypeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return INSTANCE.createErrorTypeWithArguments(kind, CollectionsKt.emptyList(), Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorType(@NotNull ErrorTypeKind kind, @NotNull TypeConstructor typeConstructor2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return this.createErrorTypeWithArguments(kind, CollectionsKt.emptyList(), typeConstructor2, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorTypeWithArguments(@NotNull ErrorTypeKind kind, @NotNull List<? extends TypeProjection> arguments2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return this.createErrorTypeWithArguments(kind, arguments2, this.createErrorTypeConstructor(kind, Arrays.copyOf(formatParams, formatParams.length)), Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorTypeWithArguments(@NotNull ErrorTypeKind kind, @NotNull List<? extends TypeProjection> arguments2, @NotNull TypeConstructor typeConstructor2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        String[] stringArray = new String[]{typeConstructor2.toString()};
        return new ErrorType(typeConstructor2, (MemberScope)ErrorUtils.createErrorScope(ErrorScopeKind.ERROR_TYPE_SCOPE, stringArray), kind, arguments2, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorTypeConstructor createErrorTypeConstructor(@NotNull ErrorTypeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return new ErrorTypeConstructor(kind, Arrays.copyOf(formatParams, formatParams.length));
    }

    public final boolean containsErrorType(@Nullable KotlinType type2) {
        if (type2 == null) {
            return false;
        }
        if (KotlinTypeKt.isError(type2)) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !this.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isError(@Nullable DeclarationDescriptor candidate) {
        if (candidate == null) return false;
        if (INSTANCE.isErrorClass(candidate)) return true;
        if (INSTANCE.isErrorClass(candidate.getContainingDeclaration())) return true;
        if (candidate != errorModule) return false;
        return true;
    }

    private final boolean isErrorClass(DeclarationDescriptor candidate) {
        return candidate instanceof ErrorClassDescriptor;
    }

    public static final boolean isUninferredTypeVariable(@Nullable KotlinType type2) {
        if (type2 == null) {
            return false;
        }
        TypeConstructor constructor = type2.getConstructor();
        return constructor instanceof ErrorTypeConstructor && ((ErrorTypeConstructor)constructor).getKind() == ErrorTypeKind.UNINFERRED_TYPE_VARIABLE;
    }

    public final boolean containsUninferredTypeVariable(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return TypeUtilsKt.contains(type2, (Function1<? super UnwrappedType, Boolean>)new Function1<KotlinType, Boolean>((Object)INSTANCE){

            public final Boolean invoke(KotlinType p0) {
                return ErrorUtils.isUninferredTypeVariable(p0);
            }
        });
    }

    @NotNull
    public final String unresolvedTypeAsItIs(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        boolean bl = TypeUtilsKt.isUnresolvedType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.types.error.ErrorTypeConstructor");
        return ((ErrorTypeConstructor)typeConstructor2).getParam(0);
    }

    static {
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[]{"unknown class"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Name name = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue(name, "special(...)");
        errorClass = new ErrorClassDescriptor(name);
        errorTypeForLoopInSupertypes = ErrorUtils.createErrorType(ErrorTypeKind.CYCLIC_SUPERTYPES, new String[0]);
        errorPropertyType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_PROPERTY_TYPE, new String[0]);
        errorProperty = new ErrorPropertyDescriptor();
        errorPropertyGroup = SetsKt.setOf(errorProperty);
    }
}

