/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.SubtypePathNode;
import org.jetbrains.kotlin.types.checker.TypeCheckerProcedureCallbacksImpl;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedureCallbacks;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a+\u0010\u0005\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0013\u0010\u0007\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0013\u0010\u000b\u001a\u00020\n*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/types/KotlinType;", "subtype", "supertype", "Lorg/jetbrains/kotlin/types/checker/TypeCheckingProcedureCallbacks;", "typeCheckingProcedureCallbacks", "findCorrespondingSupertype", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/checker/TypeCheckingProcedureCallbacks;)Lorg/jetbrains/kotlin/types/KotlinType;", "approximate", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "", "debugInfo", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)Ljava/lang/String;"})
public final class UtilsKt {
    @Nullable
    public static final KotlinType findCorrespondingSupertype(@NotNull KotlinType subtype, @NotNull KotlinType supertype, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(supertype, "supertype");
        Intrinsics.checkNotNullParameter(typeCheckingProcedureCallbacks, "typeCheckingProcedureCallbacks");
        ArrayDeque<SubtypePathNode> queue = new ArrayDeque<SubtypePathNode>();
        queue.add(new SubtypePathNode(subtype, null));
        TypeConstructor supertypeConstructor = supertype.getConstructor();
        while (!queue.isEmpty()) {
            SubtypePathNode lastPathNode = (SubtypePathNode)queue.poll();
            KotlinType currentSubtype = lastPathNode.getType();
            TypeConstructor constructor = currentSubtype.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(constructor, supertypeConstructor)) {
                KotlinType substituted = currentSubtype;
                boolean isAnyMarkedNullable = currentSubtype.isMarkedNullable();
                for (SubtypePathNode currentPathNode = lastPathNode.getPrevious(); currentPathNode != null; currentPathNode = currentPathNode.getPrevious()) {
                    KotlinType kotlinType;
                    boolean bl;
                    KotlinType currentType;
                    block10: {
                        currentType = currentPathNode.getType();
                        Iterable $this$any$iv = currentType.getArguments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                TypeProjection it = (TypeProjection)element$iv;
                                boolean bl2 = false;
                                if (!(it.getProjectionKind() != Variance.INVARIANT)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        KotlinType kotlinType2 = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(TypeConstructorSubstitution.Companion.create(currentType), false, 1, null).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT);
                        Intrinsics.checkNotNullExpressionValue(kotlinType2, "safeSubstitute(...)");
                        kotlinType = UtilsKt.approximate(kotlinType2);
                    } else {
                        KotlinType kotlinType3 = TypeConstructorSubstitution.Companion.create(currentType).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT);
                        Intrinsics.checkNotNull(kotlinType3);
                        kotlinType = kotlinType3;
                    }
                    substituted = kotlinType;
                    isAnyMarkedNullable = isAnyMarkedNullable || currentType.isMarkedNullable();
                }
                TypeConstructor substitutedConstructor = substituted.getConstructor();
                if (!typeCheckingProcedureCallbacks.assertEqualTypeConstructors(substitutedConstructor, supertypeConstructor)) {
                    throw new AssertionError((Object)("Type constructors should be equals!\nsubstitutedSuperType: " + UtilsKt.debugInfo(substitutedConstructor) + ", \n\nsupertype: " + UtilsKt.debugInfo(supertypeConstructor) + " \n" + typeCheckingProcedureCallbacks.assertEqualTypeConstructors(substitutedConstructor, supertypeConstructor)));
                }
                return TypeUtils.makeNullableAsSpecified(substituted, isAnyMarkedNullable);
            }
            for (KotlinType immediateSupertype : constructor.getSupertypes()) {
                Intrinsics.checkNotNull(immediateSupertype);
                queue.add(new SubtypePathNode(immediateSupertype, lastPathNode));
            }
        }
        return null;
    }

    public static /* synthetic */ KotlinType findCorrespondingSupertype$default(KotlinType kotlinType, KotlinType kotlinType2, TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks, int n2, Object object) {
        if ((n2 & 4) != 0) {
            typeCheckingProcedureCallbacks = new TypeCheckerProcedureCallbacksImpl();
        }
        return UtilsKt.findCorrespondingSupertype(kotlinType, kotlinType2, typeCheckingProcedureCallbacks);
    }

    private static final KotlinType approximate(KotlinType $this$approximate) {
        return CapturedTypeApproximationKt.approximateCapturedTypes($this$approximate).getUpper();
    }

    private static final String debugInfo(TypeConstructor $this$debugInfo) {
        StringBuilder stringBuilder;
        StringBuilder $this$debugInfo_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        UtilsKt.debugInfo$lambda$1$unaryPlus("type: " + $this$debugInfo, $this$debugInfo_u24lambda_u241);
        UtilsKt.debugInfo$lambda$1$unaryPlus("hashCode: " + $this$debugInfo.hashCode(), $this$debugInfo_u24lambda_u241);
        UtilsKt.debugInfo$lambda$1$unaryPlus("javaClass: " + $this$debugInfo.getClass().getCanonicalName(), $this$debugInfo_u24lambda_u241);
        for (DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)$this$debugInfo.getDeclarationDescriptor(); declarationDescriptor != null; declarationDescriptor = declarationDescriptor.getContainingDeclaration()) {
            UtilsKt.debugInfo$lambda$1$unaryPlus("fqName: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor), $this$debugInfo_u24lambda_u241);
            UtilsKt.debugInfo$lambda$1$unaryPlus("javaClass: " + declarationDescriptor.getClass().getCanonicalName(), $this$debugInfo_u24lambda_u241);
        }
        return stringBuilder.toString();
    }

    private static final StringBuilder debugInfo$lambda$1$unaryPlus(String $this$debugInfo_u24lambda_u241_u24unaryPlus, StringBuilder $this_buildString) {
        Intrinsics.checkNotNullParameter($this$debugInfo_u24lambda_u241_u24unaryPlus, "<this>");
        return $this_buildString.append($this$debugInfo_u24lambda_u241_u24unaryPlus).append('\n');
    }
}

