/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0017\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B)\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0017\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e"}, d2={"Lorg/jetbrains/kotlin/types/Variance;", "", "", "label", "", "allowsInPosition", "allowsOutPosition", "", "superpositionFactor", "<init>", "(Ljava/lang/String;ILjava/lang/String;ZZI)V", "position", "allowsPosition", "(Lorg/jetbrains/kotlin/types/Variance;)Z", "other", "superpose", "(Lorg/jetbrains/kotlin/types/Variance;)Lorg/jetbrains/kotlin/types/Variance;", "opposite", "()Lorg/jetbrains/kotlin/types/Variance;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getLabel", "Z", "getAllowsInPosition", "()Z", "getAllowsOutPosition", "I", "INVARIANT", "IN_VARIANCE", "OUT_VARIANCE"})
public final class Variance
extends Enum<Variance> {
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;
    public static final /* enum */ Variance INVARIANT = new Variance("", true, true, 0);
    public static final /* enum */ Variance IN_VARIANCE = new Variance("in", true, false, -1);
    public static final /* enum */ Variance OUT_VARIANCE = new Variance("out", false, true, 1);
    private static final /* synthetic */ Variance[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Variance(String label, boolean allowsInPosition, boolean allowsOutPosition, int superpositionFactor) {
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    public final boolean allowsPosition(@NotNull Variance position) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)position, "position");
        switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1: {
                bl = this.allowsInPosition;
                break;
            }
            case 2: {
                bl = this.allowsOutPosition;
                break;
            }
            case 3: {
                if (this.allowsInPosition && this.allowsOutPosition) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@NotNull Variance other) {
        Variance variance;
        Intrinsics.checkNotNullParameter((Object)other, "other");
        int r2 = this.superpositionFactor * other.superpositionFactor;
        switch (r2) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal factor: " + r2);
            }
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 3: {
                variance = INVARIANT;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            case 2: {
                variance = IN_VARIANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    public static Variance[] values() {
        return (Variance[])$VALUES.clone();
    }

    public static Variance valueOf(String value2) {
        return Enum.valueOf(Variance.class, value2);
    }

    @NotNull
    public static EnumEntries<Variance> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = varianceArray = new Variance[]{Variance.INVARIANT, Variance.IN_VARIANCE, Variance.OUT_VARIANCE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

