/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB%\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\u0004\b\t\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\u000fJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0097\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/types/IndexedParametersSubstitution;", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "parameters", "Lorg/jetbrains/kotlin/types/TypeProjection;", "arguments", "", "approximateContravariantCapturedTypes", "<init>", "([Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;[Lorg/jetbrains/kotlin/types/TypeProjection;Z)V", "", "argumentsList", "(Ljava/util/List;Ljava/util/List;)V", "isEmpty", "()Z", "Lorg/jetbrains/kotlin/types/KotlinType;", "key", "get", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/TypeProjection;", "[Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getParameters", "()[Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "[Lorg/jetbrains/kotlin/types/TypeProjection;", "getArguments", "()[Lorg/jetbrains/kotlin/types/TypeProjection;", "Z"})
public final class IndexedParametersSubstitution
extends TypeSubstitution {
    @NotNull
    private final TypeParameterDescriptor[] parameters;
    @NotNull
    private final TypeProjection[] arguments;
    private final boolean approximateContravariantCapturedTypes;

    public IndexedParametersSubstitution(@NotNull TypeParameterDescriptor[] parameters2, @NotNull TypeProjection[] arguments2, boolean approximateContravariantCapturedTypes) {
        boolean bl;
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        this.parameters = parameters2;
        this.arguments = arguments2;
        this.approximateContravariantCapturedTypes = approximateContravariantCapturedTypes;
        boolean bl2 = bl = this.parameters.length <= this.arguments.length;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Number of arguments should not be less than number of parameters, but: parameters=" + this.parameters.length + ", args=" + this.arguments.length;
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ IndexedParametersSubstitution(TypeParameterDescriptor[] typeParameterDescriptorArray, TypeProjection[] typeProjectionArray, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(typeParameterDescriptorArray, typeProjectionArray, bl);
    }

    @NotNull
    public final TypeParameterDescriptor[] getParameters() {
        return this.parameters;
    }

    @NotNull
    public final TypeProjection[] getArguments() {
        return this.arguments;
    }

    public IndexedParametersSubstitution(@NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull List<? extends TypeProjection> argumentsList) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(argumentsList, "argumentsList");
        Collection $this$toTypedArray$iv = parameters2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = argumentsList;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        this(thisCollection$iv.toArray(new TypeParameterDescriptor[0]), thisCollection$iv.toArray(new TypeProjection[0]), false, 4, null);
    }

    @Override
    public boolean isEmpty() {
        return this.arguments.length == 0;
    }

    @Override
    public boolean approximateContravariantCapturedTypes() {
        return this.approximateContravariantCapturedTypes;
    }

    @Override
    @Nullable
    public TypeProjection get(@NotNull KotlinType key) {
        Intrinsics.checkNotNullParameter(key, "key");
        ClassifierDescriptor classifierDescriptor = key.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return null;
        }
        TypeParameterDescriptor parameter = typeParameterDescriptor;
        int index2 = parameter.getIndex();
        if (index2 < this.parameters.length && Intrinsics.areEqual(this.parameters[index2].getTypeConstructor(), parameter.getTypeConstructor())) {
            return this.arguments[index2];
        }
        return null;
    }
}

