/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.CommonFlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeBoundsChecker;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/types/KotlinType;", "a", "b", "", "areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)Z", "type", "Lorg/jetbrains/kotlin/name/FqName;", "getBaseBoundFqNameByMutability", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/name/FqName;", "fqName", "(Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/name/FqName;"})
public final class FlexibleTypeBoundsChecker {
    @NotNull
    public static final FlexibleTypeBoundsChecker INSTANCE = new FlexibleTypeBoundsChecker();

    private FlexibleTypeBoundsChecker() {
    }

    public final boolean areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(@NotNull KotlinType a2, @NotNull KotlinType b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        Object object = a2.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
            return false;
        }
        Object fqName2 = object;
        FqName fqName3 = CommonFlexibleTypeBoundsChecker.INSTANCE.getBaseTypesToMutableEquivalent().get(fqName2);
        if (fqName3 == null && (fqName3 = CommonFlexibleTypeBoundsChecker.INSTANCE.getMutableToBaseMap().get(fqName2)) == null) {
            return false;
        }
        FqName possiblePairBound = fqName3;
        ClassifierDescriptor classifierDescriptor = b2.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual(possiblePairBound, classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null);
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull KotlinType type2) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter(type2, "type");
        Object object = type2.getConstructor().getDeclarationDescriptor();
        if (object != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null) {
            Object p0 = object;
            boolean bl = false;
            fqName2 = this.getBaseBoundFqNameByMutability((FqName)p0);
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return CommonFlexibleTypeBoundsChecker.INSTANCE.getBaseBoundFqNameByMutability(fqName2);
    }
}

