/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.types.CustomTypeParameter;
import org.jetbrains.kotlin.types.DelegatingSimpleType;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewCapturedType;
import org.jetbrains.kotlin.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.types.checker.NullabilityChecker;
import org.jetbrains.kotlin.types.model.DefinitelyNotNullTypeMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001#B\u0019\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001eR\u0014\u0010\u0018\u001a\u00020\u00048UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!"}, d2={"Lorg/jetbrains/kotlin/types/DefinitelyNotNullType;", "Lorg/jetbrains/kotlin/types/DelegatingSimpleType;", "Lorg/jetbrains/kotlin/types/CustomTypeParameter;", "Lorg/jetbrains/kotlin/types/model/DefinitelyNotNullTypeMarker;", "Lorg/jetbrains/kotlin/types/SimpleType;", "original", "", "useCorrectedNullabilityForTypeParameters", "<init>", "(Lorg/jetbrains/kotlin/types/SimpleType;Z)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "replacement", "substitutionResult", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/TypeAttributes;", "newAttributes", "replaceAttributes", "(Lorg/jetbrains/kotlin/types/TypeAttributes;)Lorg/jetbrains/kotlin/types/SimpleType;", "newNullability", "makeNullableAsSpecified", "(Z)Lorg/jetbrains/kotlin/types/SimpleType;", "", "toString", "()Ljava/lang/String;", "delegate", "replaceDelegate", "(Lorg/jetbrains/kotlin/types/SimpleType;)Lorg/jetbrains/kotlin/types/DefinitelyNotNullType;", "Lorg/jetbrains/kotlin/types/SimpleType;", "getOriginal", "()Lorg/jetbrains/kotlin/types/SimpleType;", "Z", "getDelegate", "isMarkedNullable", "()Z", "isTypeParameter", "Companion"})
public final class DefinitelyNotNullType
extends DelegatingSimpleType
implements CustomTypeParameter,
DefinitelyNotNullTypeMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleType original;
    private final boolean useCorrectedNullabilityForTypeParameters;

    private DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters) {
        this.original = original;
        this.useCorrectedNullabilityForTypeParameters = useCorrectedNullabilityForTypeParameters;
    }

    @NotNull
    public final SimpleType getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    protected SimpleType getDelegate() {
        return this.original;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    public boolean isTypeParameter() {
        return this.getDelegate().getConstructor() instanceof NewTypeVariableConstructor || this.getDelegate().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    @Override
    @NotNull
    public KotlinType substitutionResult(@NotNull KotlinType replacement) {
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(replacement.unwrap(), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter(newAttributes, "newAttributes");
        return new DefinitelyNotNullType(this.getDelegate().replaceAttributes(newAttributes), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType makeNullableAsSpecified(boolean newNullability) {
        return newNullability ? this.getDelegate().makeNullableAsSpecified(newNullability) : (SimpleType)this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getDelegate() + " & Any";
    }

    @Override
    @NotNull
    public DefinitelyNotNullType replaceDelegate(@NotNull SimpleType delegate) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        return new DefinitelyNotNullType(delegate, this.useCorrectedNullabilityForTypeParameters);
    }

    public /* synthetic */ DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters, DefaultConstructorMarker $constructor_marker) {
        this(original, useCorrectedNullabilityForTypeParameters);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u0006*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/types/DefinitelyNotNullType$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "type", "", "useCorrectedNullabilityForTypeParameters", "avoidCheckingActualTypeNullability", "Lorg/jetbrains/kotlin/types/DefinitelyNotNullType;", "makeDefinitelyNotNull", "(Lorg/jetbrains/kotlin/types/UnwrappedType;ZZ)Lorg/jetbrains/kotlin/types/DefinitelyNotNullType;", "useCorrectedNullabilityForFlexibleTypeParameters", "makesSenseToBeDefinitelyNotNull", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Z)Z", "canHaveUndefinedNullability", "(Lorg/jetbrains/kotlin/types/UnwrappedType;)Z"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type2, boolean useCorrectedNullabilityForTypeParameters, boolean avoidCheckingActualTypeNullability) {
            DefinitelyNotNullType definitelyNotNullType;
            Intrinsics.checkNotNullParameter(type2, "type");
            if (type2 instanceof DefinitelyNotNullType) {
                definitelyNotNullType = (DefinitelyNotNullType)type2;
            } else if (avoidCheckingActualTypeNullability || this.makesSenseToBeDefinitelyNotNull(type2, useCorrectedNullabilityForTypeParameters)) {
                if (type2 instanceof FlexibleType) {
                    boolean bl = Intrinsics.areEqual(((FlexibleType)type2).getLowerBound().getConstructor(), ((FlexibleType)type2).getUpperBound().getConstructor());
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl2 = false;
                        String string = "DefinitelyNotNullType for flexible type (" + type2 + ") can be created only from type variable with the same constructor for bounds";
                        throw new AssertionError((Object)string);
                    }
                }
                definitelyNotNullType = new DefinitelyNotNullType(FlexibleTypesKt.lowerIfFlexible(type2).makeNullableAsSpecified(false), useCorrectedNullabilityForTypeParameters, null);
            } else {
                definitelyNotNullType = null;
            }
            return definitelyNotNullType;
        }

        public static /* synthetic */ DefinitelyNotNullType makeDefinitelyNotNull$default(Companion companion, UnwrappedType unwrappedType, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            if ((n2 & 4) != 0) {
                bl2 = false;
            }
            return companion.makeDefinitelyNotNull(unwrappedType, bl, bl2);
        }

        private final boolean makesSenseToBeDefinitelyNotNull(UnwrappedType type2, boolean useCorrectedNullabilityForFlexibleTypeParameters) {
            if (!this.canHaveUndefinedNullability(type2)) {
                return false;
            }
            if (type2 instanceof StubTypeForBuilderInference) {
                return TypeUtils.isNullableType(type2);
            }
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptorImpl typeParameterDescriptorImpl = classifierDescriptor instanceof TypeParameterDescriptorImpl ? (TypeParameterDescriptorImpl)classifierDescriptor : null;
            boolean bl = typeParameterDescriptorImpl != null ? !typeParameterDescriptorImpl.isInitialized() : false;
            if (bl) {
                return true;
            }
            if (useCorrectedNullabilityForFlexibleTypeParameters && type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                return TypeUtils.isNullableType(type2);
            }
            return !NullabilityChecker.INSTANCE.isSubtypeOfAny(type2);
        }

        private final boolean canHaveUndefinedNullability(UnwrappedType $this$canHaveUndefinedNullability) {
            return $this$canHaveUndefinedNullability.getConstructor() instanceof NewTypeVariableConstructor || $this$canHaveUndefinedNullability.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor || $this$canHaveUndefinedNullability instanceof NewCapturedType || $this$canHaveUndefinedNullability instanceof StubTypeForBuilderInference;
        }

        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type2, boolean useCorrectedNullabilityForTypeParameters) {
            Intrinsics.checkNotNullParameter(type2, "type");
            return org.jetbrains.kotlin.types.DefinitelyNotNullType$Companion.makeDefinitelyNotNull$default(this, type2, useCorrectedNullabilityForTypeParameters, false, 4, null);
        }

        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            return org.jetbrains.kotlin.types.DefinitelyNotNullType$Companion.makeDefinitelyNotNull$default(this, type2, false, false, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

