/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class DynamicTypeDeserializer
implements FlexibleTypeDeserializer {
    @NotNull
    public static final DynamicTypeDeserializer INSTANCE = new DynamicTypeDeserializer();

    private DynamicTypeDeserializer() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KotlinType create(@NotNull ProtoBuf.Type proto, @NotNull String flexibleId, @NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(flexibleId, "flexibleId");
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        if (!Intrinsics.areEqual(flexibleId, "kotlin.DynamicType")) {
            String[] stringArray = new String[]{flexibleId, lowerBound.toString(), upperBound.toString()};
            return ErrorUtils.createErrorType(ErrorTypeKind.UNEXPECTED_FLEXIBLE_TYPE_ID, stringArray);
        }
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(lowerBound).getNothingType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getNothingType(...)");
        if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(lowerBound, simpleType2)) {
            SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(upperBound).getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue(simpleType3, "getNullableAnyType(...)");
            if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(upperBound, simpleType3)) {
                kotlinType = DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(lowerBound));
                return kotlinType;
            }
        }
        String[] stringArray = new String[]{lowerBound.toString(), upperBound.toString()};
        kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ILLEGAL_TYPE_RANGE_FOR_DYNAMIC, stringArray);
        return kotlinType;
    }
}

